/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.util.animation.Interpolation;

public record Point3D(float x, float y, float z) {
    public static final Point3D ORIGIN = new Point3D(0.0f, 0.0f, 0.0f);
    public static final float EPSILON = 0.001f;

    public boolean isOrigin() {
        return Math.abs(this.x) < 0.001f && Math.abs(this.y) < 0.001f && Math.abs(this.z) < 0.001f;
    }

    public float distanceTo(Point3D other) {
        float deltaX = Math.abs(other.x - this.x);
        float deltaY = Math.abs(other.y - this.y);
        float deltaZ = Math.abs(other.z - this.z);
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public Point3D findCenter(Point3D other) {
        float centerX = (this.x + other.x) / 2.0f;
        float centerY = (this.y + other.y) / 2.0f;
        float centerZ = (this.z + other.z) / 2.0f;
        return new Point3D(centerX, centerY, centerZ);
    }

    public Point3D interpolate(Point3D other, float delta, Interpolation method) {
        float interpolatedX = method.interpolate(this.x, other.x, delta);
        float interpolatedY = method.interpolate(this.y, other.y, delta);
        float interpolatedZ = method.interpolate(this.z, other.z, delta);
        return new Point3D(interpolatedX, interpolatedY, interpolatedZ);
    }

    public Point3D interpolate(Point3D other, float delta) {
        return this.interpolate(other, delta, Interpolation.LINEAR);
    }

    public Point3D move(float deltaX, float deltaY, float deltaZ) {
        return new Point3D(this.x + deltaX, this.y + deltaY, this.z + deltaZ);
    }

    public Point3D move(Point3D other) {
        return this.move(other.x, other.y, other.z);
    }

    @Override
    public String toString() {
        return String.format("(%d, %d, %d)", Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }
}

