/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import lombok.Generated;
import nl.colorize.multimedialib.math.Coordinate;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Size;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.util.TextUtils;

public class Canvas {
    private Size preferredSize;
    private ScaleStrategy scaleStrategy;
    private Size screenSize;
    private Coordinate screenOffset;

    public Canvas(Size preferredSize, ScaleStrategy scaleStrategy) {
        this.preferredSize = preferredSize;
        this.scaleStrategy = scaleStrategy;
        this.screenSize = preferredSize;
        this.screenOffset = new Coordinate(0, 0);
    }

    public Canvas(int preferredWidth, int preferredHeight, ScaleStrategy scaleStrategy) {
        this(new Size(preferredWidth, preferredHeight), scaleStrategy);
    }

    public void resizeScreen(int screenWidth, int screenHeight) {
        this.screenSize = new Size(Math.max(screenWidth, 1), Math.max(screenHeight, 1));
    }

    public void offsetScreen(int offsetX, int offsetY) {
        this.screenOffset = new Coordinate(offsetX, offsetY);
    }

    public int getWidth() {
        return Math.round((float)this.screenSize.width() / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)this.screenSize.height() / this.getZoomLevel());
    }

    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public Rect getBounds() {
        return new Rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public Point2D getCenter() {
        return new Point2D((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public boolean isLandscape() {
        return this.screenSize.width() >= this.screenSize.height();
    }

    public boolean isPortait() {
        return !this.isLandscape();
    }

    public float getZoomLevel() {
        return this.scaleStrategy.getZoomLevel(this);
    }

    public float toCanvasX(int screenX) {
        return (float)(screenX - this.screenOffset.x()) / this.getZoomLevel();
    }

    public float toCanvasX(Point2D point) {
        return this.toCanvasX(Math.round(point.x()));
    }

    public float toCanvasY(int screenY) {
        return (float)(screenY - this.screenOffset.y()) / this.getZoomLevel();
    }

    public float toCanvasY(Point2D point) {
        return this.toCanvasY(Math.round(point.y()));
    }

    public float toScreenX(float canvasX) {
        return canvasX * this.getZoomLevel() + (float)this.screenOffset.x();
    }

    public float toScreenX(Point2D point) {
        return this.toScreenX(point.x());
    }

    public float toScreenY(float canvasY) {
        return canvasY * this.getZoomLevel() + (float)this.screenOffset.y();
    }

    public float toScreenY(Point2D point) {
        return this.toScreenY(point.y());
    }

    public String toString() {
        float zoomLevel = this.getZoomLevel();
        return this.getWidth() + "x" + this.getHeight() + " @ " + TextUtils.numberFormat((float)zoomLevel, (int)1) + "x";
    }

    @Generated
    public Size getPreferredSize() {
        return this.preferredSize;
    }

    @Generated
    public ScaleStrategy getScaleStrategy() {
        return this.scaleStrategy;
    }

    @Generated
    public Size getScreenSize() {
        return this.screenSize;
    }

    @Generated
    public Coordinate getScreenOffset() {
        return this.screenOffset;
    }
}

