/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Properties;
import nl.colorize.multimedialib.renderer.SpriteAtlasLoader;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.LoadStatus;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.SpriteAtlas;
import nl.colorize.util.PropertyUtils;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.SubscribableCollection;
import nl.colorize.util.TranslationBundle;

public interface MediaLoader {
    public Image loadImage(ResourceFile var1);

    default public SpriteAtlas loadAtlas(ResourceFile file) {
        SpriteAtlasLoader atlasLoader = new SpriteAtlasLoader(this);
        return atlasLoader.load(file);
    }

    public Audio loadAudio(ResourceFile var1);

    public FontFace loadFont(ResourceFile var1, String var2, int var3, ColorRGB var4);

    default public FontFace loadDefaultFont(int size, ColorRGB color) {
        ResourceFile file = new ResourceFile("OpenSans-Regular.ttf");
        return this.loadFont(file, "Open Sans", size, color);
    }

    public Mesh loadModel(ResourceFile var1);

    public String loadText(ResourceFile var1);

    default public List<String> loadTextLines(ResourceFile file) {
        return Splitter.on((String)"\n").splitToList((CharSequence)this.loadText(file));
    }

    default public Properties loadProperties(ResourceFile file) {
        String contents = this.loadText(file);
        return PropertyUtils.loadProperties((String)contents);
    }

    default public TranslationBundle loadTranslationBundle(ResourceFile file) {
        Properties properties = this.loadProperties(file);
        return TranslationBundle.from((Properties)properties);
    }

    public boolean containsResourceFile(ResourceFile var1);

    public Properties loadApplicationData(String var1);

    public void saveApplicationData(String var1, Properties var2);

    public SubscribableCollection<LoadStatus> getLoadStatus();
}

