/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import lombok.Generated;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.math.Size;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.AWTInput;
import nl.colorize.multimedialib.renderer.java2d.Java2DGraphicsContext;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.MacIntegration;
import nl.colorize.util.swing.SwingUtils;
import nl.colorize.util.swing.Utils2D;

public class Java2DRenderer
implements Renderer,
SceneContext {
    private RenderConfig config;
    private AWTInput input;
    private StandardMediaLoader mediaLoader;
    private Network network;
    private SceneManager sceneManager;
    private Stage stage;
    private JFrame window;
    private Java2DGraphicsContext graphicsContext;
    private AtomicBoolean canvasDirty;
    private AtomicBoolean terminated;
    private static final boolean ANTI_ALIASING = true;
    private static final boolean BILINEAR_SCALING = true;
    private static final Logger LOGGER = LogHelper.getLogger(Java2DRenderer.class);

    public Java2DRenderer() {
        SwingUtils.initializeSwing();
        this.canvasDirty = new AtomicBoolean(true);
        this.terminated = new AtomicBoolean(false);
    }

    @Override
    public void start(RenderConfig config, Scene initialScene) {
        this.config = config;
        this.window = this.initializeWindow(config.getWindowOptions());
        this.input = this.initializeInput();
        this.mediaLoader = new StandardMediaLoader();
        this.graphicsContext = new Java2DGraphicsContext(config.getCanvas(), StandardMediaLoader.fontCache);
        this.network = new StandardNetwork();
        this.sceneManager = new SceneManager();
        this.stage = new Stage(config.getGraphicsMode(), config.getCanvas());
        this.changeScene(initialScene);
        Thread renderingThread = new Thread(this::runAnimationLoop, "MultimediaLib-Java2D-Renderer");
        renderingThread.start();
    }

    private JFrame initializeWindow(WindowOptions windowOptions) {
        this.window = new JFrame();
        this.window.setDefaultCloseOperation(2);
        this.window.setResizable(true);
        this.window.setIgnoreRepaint(true);
        this.window.setFocusTraversalKeysEnabled(false);
        this.window.addWindowListener(this.createWindowCloseListener());
        this.window.addComponentListener(this.createResizeListener());
        this.window.setTitle(windowOptions.getTitle());
        this.window.setIconImage(this.loadIcon(windowOptions).getImage());
        this.window.getContentPane().setPreferredSize(this.getWindowSize());
        if (windowOptions.isFullscreen()) {
            SwingUtils.goFullScreen((JFrame)this.window);
        }
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.window.setVisible(true);
        this.window.createBufferStrategy(2);
        if (Platform.isMac() && windowOptions.getAppMenu() != null && !windowOptions.isEmbedded()) {
            MacIntegration.setApplicationMenuListener((ApplicationMenuListener)windowOptions.getAppMenu());
        }
        return this.window;
    }

    private Dimension getWindowSize() {
        Size windowSize = this.config.getWindowOptions().getWindowSize().orElse(this.config.getCanvas().getSize());
        return new Dimension(windowSize.width(), windowSize.height());
    }

    private AWTInput initializeInput() {
        AWTInput input = new AWTInput(this.config);
        this.window.addKeyListener(input);
        this.window.addMouseListener(input);
        this.window.addMouseMotionListener(input);
        return input;
    }

    private ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Java2DRenderer.this.canvasDirty.set(true);
            }
        };
    }

    private WindowListener createWindowCloseListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LOGGER.info("Closing window");
                Java2DRenderer.this.terminated.set(true);
                if (!Java2DRenderer.this.config.getWindowOptions().isEmbedded()) {
                    System.exit(0);
                }
            }
        };
    }

    private ImageIcon loadIcon(WindowOptions windowOptions) {
        ResourceFile iconFile = new ResourceFile(windowOptions.getIconFile().path());
        return SwingUtils.loadIcon((ResourceFile)iconFile);
    }

    private void runAnimationLoop() {
        Stopwatch timer = new Stopwatch();
        long targetFrameTime = Math.round(1000.0f / (float)this.config.getFramerate());
        try {
            while (!this.terminated.get()) {
                long oversleep = Math.max(timer.tick() - targetFrameTime, 0L);
                if (this.canvasDirty.get()) {
                    this.canvasDirty.set(false);
                    this.prepareCanvas();
                }
                if (this.sceneManager.requestFrameUpdate(this) > 0) {
                    this.renderFrame();
                }
                long frameTime = timer.tock();
                long sleepTime = targetFrameTime - frameTime - oversleep;
                Thread.yield();
                Thread.sleep(Math.clamp(sleepTime, 1L, 100L));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during animation loop", e);
            this.config.getErrorHandler().onError(this, e);
            this.terminate();
        }
    }

    private void renderFrame() {
        BufferStrategy windowBuffer = this.window.getBufferStrategy();
        Graphics bufferGraphics = this.accessWindowGraphics(windowBuffer);
        FrameStats frameStats = this.sceneManager.getFrameStats();
        if (bufferGraphics != null) {
            frameStats.markStart("$$frameRender");
            Graphics2D g2 = Utils2D.createGraphics((Graphics)bufferGraphics, (boolean)true, (boolean)true);
            this.graphicsContext.bind(g2);
            this.getStage().visit(this.graphicsContext);
            this.blitGraphicsContext(windowBuffer);
            this.graphicsContext.dispose();
            frameStats.markEnd("$$frameRender");
        }
    }

    private Graphics accessWindowGraphics(BufferStrategy windowBuffer) {
        try {
            return windowBuffer.getDrawGraphics();
        }
        catch (IllegalStateException e) {
            LOGGER.warning("Window buffer graphics not available: " + e.getMessage());
            return null;
        }
    }

    private void prepareCanvas() {
        Insets windowInsets = this.window.getInsets();
        int windowWidth = this.window.getWidth() - windowInsets.left - windowInsets.right;
        int windowHeight = this.window.getHeight() - windowInsets.top - windowInsets.bottom;
        this.config.getCanvas().resizeScreen(windowWidth, windowHeight);
        this.config.getCanvas().offsetScreen(windowInsets.left, windowInsets.top);
    }

    private void blitGraphicsContext(BufferStrategy windowBuffer) {
        if (!windowBuffer.contentsLost()) {
            windowBuffer.show();
            if (Platform.isLinux()) {
                this.window.getToolkit().sync();
            }
        }
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2D project(Point3D position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupported(GraphicsMode graphicsMode) {
        return graphicsMode == GraphicsMode.MODE_2D;
    }

    @Override
    public void terminate() {
        System.exit(0);
    }

    @Override
    public void takeScreenshot(File screenshotFile) {
        Java2DGraphicsContext screenshotContext = new Java2DGraphicsContext(this.config.getCanvas(), StandardMediaLoader.fontCache);
        BufferedImage image = new BufferedImage(this.window.getWidth(), this.window.getHeight(), 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)false, (boolean)false);
        screenshotContext.bind(g2);
        this.getStage().visit(screenshotContext);
        screenshotContext.dispose();
        try {
            Utils2D.savePNG((BufferedImage)image, (File)screenshotFile);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save screenshot", e);
        }
    }

    @Override
    public String getRendererName() {
        return "Java2D renderer";
    }

    @Override
    @Generated
    public RenderConfig getConfig() {
        return this.config;
    }

    @Override
    @Generated
    public AWTInput getInput() {
        return this.input;
    }

    @Override
    @Generated
    public StandardMediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    @Generated
    public Network getNetwork() {
        return this.network;
    }

    @Override
    @Generated
    public SceneManager getSceneManager() {
        return this.sceneManager;
    }

    @Override
    @Generated
    public Stage getStage() {
        return this.stage;
    }
}

