/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import lombok.Generated;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;

public class GDXImage
implements Image {
    private Texture texture;
    private TextureRegion textureRegion;
    private Pixmap textureData;
    private Region region;

    public GDXImage(Texture texture, Region region) {
        float u0 = (float)region.x() / (float)texture.getWidth();
        float v0 = (float)region.y() / (float)texture.getHeight();
        float u1 = (float)region.x1() / (float)texture.getWidth();
        float v1 = (float)region.y1() / (float)texture.getHeight();
        this.texture = texture;
        this.textureRegion = new TextureRegion(texture, u0, v0, u1, v1);
        this.region = region;
    }

    public GDXImage(Texture texture) {
        this(texture, new Region(0, 0, texture.getWidth(), texture.getHeight()));
    }

    @Override
    public Image extractRegion(Region subRegion) {
        Region absoluteSubRegion = subRegion.move(this.region.x(), this.region.y());
        return new GDXImage(this.texture, absoluteSubRegion);
    }

    private void loadTextureData() {
        if (this.textureData == null) {
            TextureData data = this.texture.getTextureData();
            data.prepare();
            this.textureData = data.consumePixmap();
        }
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(this.region.x() + x, this.region.y() + y);
        return GDXMediaLoader.toColor(new Color(rgba));
    }

    @Override
    public int getAlpha(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(this.region.x() + x, this.region.y() + y);
        return Math.round(new Color((int)rgba).a * 100.0f);
    }

    @Generated
    public Texture getTexture() {
        return this.texture;
    }

    @Generated
    public TextureRegion getTextureRegion() {
        return this.textureRegion;
    }

    @Generated
    public Pixmap getTextureData() {
        return this.textureData;
    }

    @Override
    @Generated
    public Region getRegion() {
        return this.region;
    }
}

