/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.graphics.g3d.loader.ObjLoader;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.UBJsonReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import net.mgsx.gltf.loaders.gltf.GLTFLoader;
import net.mgsx.gltf.scene3d.scene.SceneAsset;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXAudio;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXModel;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.LoadStatus;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.SubscribableCollection;
import nl.colorize.util.stats.Cache;

public class GDXMediaLoader
implements MediaLoader,
Disposable {
    private List<Disposable> loaded = new ArrayList<Disposable>();
    private Cache<FontFace, BitmapFont> fontCache;
    private StandardMediaLoader appDataDelegate;
    private GLTFLoader gltfLoader;
    private G3dModelLoader g3dLoader;
    private SubscribableCollection<LoadStatus> loadStatus = SubscribableCollection.wrap(new CopyOnWriteArrayList());
    private static final Texture.TextureFilter TEXTURE_FILTER = Texture.TextureFilter.Linear;
    private static final int FONT_CACHE_SIZE = 100;
    private static final int BITMAP_FONT_SCALE = 2;

    public GDXMediaLoader() {
        this.fontCache = Cache.from(this::generateBitmapFont, (int)100);
        this.appDataDelegate = new StandardMediaLoader();
        this.gltfLoader = new GLTFLoader();
        this.g3dLoader = new G3dModelLoader((BaseJsonReader)new UBJsonReader(), (FileHandleResolver)new InternalFileHandleResolver());
    }

    @Override
    public Image loadImage(ResourceFile file) {
        Texture texture = new Texture(this.getFileHandle(file));
        texture.setFilter(TEXTURE_FILTER, TEXTURE_FILTER);
        this.loaded.add((Disposable)texture);
        return new GDXImage(texture);
    }

    @Override
    public Audio loadAudio(ResourceFile file) {
        Sound sound = Gdx.audio.newSound(this.getFileHandle(file));
        this.loaded.add((Disposable)sound);
        return new GDXAudio(sound);
    }

    @Override
    public FontFace loadFont(ResourceFile file, String family, int size, ColorRGB color) {
        FontFace font = new FontFace(file, family, size, color);
        this.getBitmapFont(font);
        return font;
    }

    protected BitmapFont getBitmapFont(FontFace font) {
        return (BitmapFont)this.fontCache.get((Object)font);
    }

    private BitmapFont generateBitmapFont(FontFace font) {
        FreeTypeFontGenerator.FreeTypeFontParameter config = new FreeTypeFontGenerator.FreeTypeFontParameter();
        config.size = font.size() * 2;
        config.color = GDXMediaLoader.toColor(font.color());
        config.minFilter = TEXTURE_FILTER;
        config.magFilter = TEXTURE_FILTER;
        FileHandle file = this.getFileHandle(font.origin());
        FreeTypeFontGenerator fontGenerator = new FreeTypeFontGenerator(file);
        BitmapFont bitmapFont = fontGenerator.generateFont(config);
        bitmapFont.getData().setScale(0.5f);
        fontGenerator.dispose();
        return bitmapFont;
    }

    @Override
    public String loadText(ResourceFile file) {
        return this.getFileHandle(file).readString("UTF-8");
    }

    @Override
    public Mesh loadModel(ResourceFile file) {
        Model model = this.loadModel(this.getFileHandle(file));
        return new GDXModel(model);
    }

    private Model loadModel(FileHandle file) {
        if (file.toString().endsWith(".g3db")) {
            return this.g3dLoader.loadModel(file);
        }
        if (file.toString().endsWith(".gltf")) {
            SceneAsset sceneAsset = this.gltfLoader.load(file, true);
            return sceneAsset.scene.model;
        }
        if (file.toString().endsWith(".obj")) {
            ObjLoader objLoader = new ObjLoader();
            return objLoader.loadModel(file);
        }
        throw new MediaException("Unsupported model file format: " + String.valueOf(file));
    }

    @Override
    public boolean containsResourceFile(ResourceFile file) {
        return this.getFileHandle(file).exists();
    }

    @Override
    public Properties loadApplicationData(String appName) {
        return this.appDataDelegate.loadApplicationData(appName);
    }

    @Override
    public void saveApplicationData(String appName, Properties data) {
        this.appDataDelegate.saveApplicationData(appName, data);
    }

    private FileHandle getFileHandle(ResourceFile file) {
        return Gdx.files.internal(file.path());
    }

    public void dispose() {
        this.loaded.forEach(Disposable::dispose);
        this.loaded.clear();
        this.fontCache.invalidate();
    }

    protected static Color toColor(ColorRGB color) {
        return new Color((float)color.r() / 255.0f, (float)color.g() / 255.0f, (float)color.b() / 255.0f, 1.0f);
    }

    protected static ColorRGB toColor(Color color) {
        return new ColorRGB(Math.round(color.r * 255.0f), Math.round(color.g * 255.0f), Math.round(color.b * 255.0f));
    }

    @Override
    @Generated
    public SubscribableCollection<LoadStatus> getLoadStatus() {
        return this.loadStatus;
    }
}

