/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import lombok.Generated;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Group;
import nl.colorize.multimedialib.stage.Light;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.Transform3D;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;

public class HtmlCanvasGraphics
implements TeaGraphics {
    private Canvas sceneCanvas;
    private TeaMediaLoader mediaLoader;
    private HTMLCanvasElement htmlCanvas;
    private CanvasRenderingContext2D context;

    @Override
    public void init(SceneContext sceneContext) {
        this.sceneCanvas = sceneContext.getCanvas();
        this.mediaLoader = (TeaMediaLoader)sceneContext.getMediaLoader();
        HTMLDocument document = Window.current().getDocument();
        HTMLElement container = document.getElementById("multimediaLibContainer");
        this.htmlCanvas = this.createFullScreenCanvas(container);
        this.context = (CanvasRenderingContext2D)this.htmlCanvas.getContext("2d");
    }

    private HTMLCanvasElement createFullScreenCanvas(HTMLElement container) {
        Window window = Window.current();
        HTMLDocument document = window.getDocument();
        HTMLCanvasElement canvas = (HTMLCanvasElement)document.createElement("canvas");
        container.appendChild((Node)canvas);
        this.resizeCanvas(canvas, container);
        window.addEventListener("resize", e -> this.resizeCanvas(canvas, container));
        return canvas;
    }

    private void resizeCanvas(HTMLCanvasElement canvas, HTMLElement container) {
        HTMLDocument document = Window.current().getDocument();
        int width = container.getOffsetWidth();
        int height = document.getDocumentElement().getClientHeight();
        this.resizeCanvas(canvas, width, height);
    }

    private void resizeCanvas(HTMLCanvasElement canvas, int width, int height) {
        Window window = Window.current();
        float devicePixelRatio = (float)window.getDevicePixelRatio();
        canvas.getStyle().setProperty("width", width + "px");
        canvas.getStyle().setProperty("height", height + "px");
        canvas.setWidth(Math.round((float)width * devicePixelRatio));
        canvas.setHeight(Math.round((float)height * devicePixelRatio));
    }

    @Override
    public int getDisplayWidth() {
        return this.htmlCanvas.getWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this.htmlCanvas.getHeight();
    }

    @Override
    public boolean shouldVisitAllNodes() {
        return false;
    }

    @Override
    public void visitContainer(Container container, Transform globalTransform) {
    }

    @Override
    public void prepareStage(Stage stage) {
        this.context.clearRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.context.setFillStyle(color.toHex());
        this.context.fillRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
    }

    @Override
    public void drawSprite(Sprite sprite, Transform globalTransform) {
        TeaImage teaImage = (TeaImage)sprite.getCurrentGraphics();
        if ((float)teaImage.getWidth() > 0.0f && (float)teaImage.getHeight() > 0.0f) {
            this.drawImage(teaImage, teaImage.getRegion(), globalTransform);
        }
    }

    private void drawImage(TeaImage image, Region region, Transform transform) {
        CanvasImageSource source = this.prepareImage(image, transform.getMaskColor());
        Point2D position = transform.getPosition();
        if (source == null) {
            return;
        }
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.translate((double)this.toScreenX(position), (double)this.toScreenY(position));
        this.context.rotate((double)transform.getRotation().degrees() * Math.PI / 180.0);
        this.context.scale((double)(transform.getScaleX() * this.sceneCanvas.getZoomLevel() / 100.0f), (double)(transform.getScaleY() * this.sceneCanvas.getZoomLevel() / 100.0f));
        this.context.drawImage(source, (double)region.x(), (double)region.y(), (double)region.width(), (double)region.height(), (double)((float)(-region.width()) / 2.0f), (double)((float)(-region.height()) / 2.0f), (double)region.width(), (double)region.height());
        this.context.setGlobalAlpha(1.0);
        this.context.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    private CanvasImageSource prepareImage(TeaImage image, ColorRGB mask) {
        if (!image.isLoaded()) {
            return null;
        }
        if (mask == null) {
            return image.getImageElement().orElse(null);
        }
        return this.mediaLoader.applyMask(image, mask);
    }

    @Override
    public void drawLine(Primitive graphic, Line line, Transform globalTransform) {
        this.context.setStrokeStyle(graphic.getColor().toHex());
        this.context.setLineWidth((double)graphic.getStroke());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(line.start()), (double)this.toScreenY(line.start()));
        this.context.lineTo((double)this.toScreenX(line.end()), (double)this.toScreenY(line.end()));
        this.context.stroke();
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line, Transform globalTransform) {
        this.context.setStrokeStyle(graphic.getColor().toHex());
        this.context.setLineWidth((double)graphic.getStroke());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(line.getHead()), (double)this.toScreenY(line.getHead()));
        for (Point2D p : line.points()) {
            this.context.lineTo((double)this.toScreenX(p), (double)this.toScreenY(p));
        }
        this.context.stroke();
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect, Transform globalTransformt) {
        this.context.setGlobalAlpha((double)(globalTransformt.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.fillRect((double)this.toScreenX(rect.x()), (double)this.toScreenY(rect.y()), (double)(rect.width() * this.sceneCanvas.getZoomLevel()), (double)(rect.height() * this.sceneCanvas.getZoomLevel()));
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle, Transform globalTransform) {
        this.context.setGlobalAlpha((double)(globalTransform.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.arc((double)this.toScreenX(circle.center().x()), (double)this.toScreenY(circle.center().y()), (double)(circle.radius() * this.sceneCanvas.getZoomLevel()), 0.0, Math.PI * 2);
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon, Transform globalTransform) {
        this.context.setGlobalAlpha((double)(globalTransform.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(polygon.getPointX(0)), (double)this.toScreenY(polygon.getPointY(0)));
        for (int i = 1; i < polygon.getNumPoints(); ++i) {
            this.context.lineTo((double)this.toScreenX(polygon.getPointX(i)), (double)this.toScreenY(polygon.getPointY(i)));
        }
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawText(Text text, Transform globalTransform) {
        FontFace font = text.getFont().scale(this.sceneCanvas);
        this.context.setGlobalAlpha((double)(globalTransform.getAlpha() / 100.0f));
        this.context.setFont(this.getFontString(font));
        this.context.setFillStyle(font.color().toHex());
        this.context.setTextAlign(text.getAlign().toString().toLowerCase());
        text.forLines((i, line) -> {
            float y = this.toScreenY(globalTransform.getPosition().y() + (float)i.intValue() * text.getLineHeight());
            this.context.fillText(line, (double)this.toScreenX(globalTransform.getPosition()), (double)y);
        });
        this.context.setGlobalAlpha(1.0);
    }

    private String getFontString(FontFace font) {
        return font.size() + "px " + font.family();
    }

    @Override
    public void visitGroup(Group group, Transform3D globalTransform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawMesh(Mesh mesh, Transform3D globalTransform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawLight(Light light, Transform3D globalTransform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2D project(Point3D position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        throw new UnsupportedOperationException();
    }

    private float toScreenX(float x) {
        return this.sceneCanvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.sceneCanvas.toScreenX(point.x());
    }

    private float toScreenY(float y) {
        return this.sceneCanvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.sceneCanvas.toScreenY(point.y());
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }

    @Generated
    public HTMLCanvasElement getHtmlCanvas() {
        return this.htmlCanvas;
    }
}

