/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import lombok.Generated;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.HtmlCanvasGraphics;
import nl.colorize.multimedialib.renderer.teavm.PixiGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.TeaNetwork;
import nl.colorize.multimedialib.renderer.teavm.ThreeGraphics;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Stage;
import org.teavm.jso.browser.Window;

public class TeaRenderer
implements Renderer,
SceneContext {
    private RenderConfig config;
    private TeaGraphics graphics;
    private TeaInputDevice input;
    private TeaMediaLoader mediaLoader;
    private TeaNetwork network;
    private SceneManager sceneManager;
    private Stage stage;

    public TeaRenderer(TeaGraphics graphics) {
        this.graphics = graphics;
    }

    @Override
    public void start(RenderConfig config, Scene initialScene) {
        this.config = config;
        this.network = new TeaNetwork();
        this.sceneManager = new SceneManager();
        this.stage = new Stage(config.getGraphicsMode(), config.getCanvas());
        this.mediaLoader = new TeaMediaLoader(config.getGraphicsMode());
        this.input = new TeaInputDevice(config.getCanvas(), this.graphics);
        this.input.bindEventHandlers();
        this.graphics.init(this);
        this.sceneManager.changeScene(initialScene);
        Browser.getBrowserBridge().prepareAnimationLoop();
        Browser.getBrowserBridge().registerErrorHandler(this::handleError);
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private void onAnimationFrame(double timestamp) {
        if (this.prepareCanvas() && this.sceneManager.requestFrameUpdate(this) > 0) {
            this.sceneManager.getFrameStats().markStart("$$frameRender");
            this.getStage().visit(this.graphics);
            this.sceneManager.getFrameStats().markEnd("$$frameRender");
            this.input.reset();
        }
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private boolean prepareCanvas() {
        int width = this.graphics.getDisplayWidth();
        int height = this.graphics.getDisplayHeight();
        if (width > 0 || height > 0) {
            this.getCanvas().resizeScreen(width, height);
            return true;
        }
        return false;
    }

    private void handleError(String error) {
        RuntimeException cause = new RuntimeException("JavaScript error\n\n" + error);
        this.config.getErrorHandler().onError(this, cause);
    }

    @Override
    public void terminate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        return this.graphics.createMesh(shape, color);
    }

    @Override
    public Point2D project(Point3D position) {
        return this.graphics.project(position);
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        return this.graphics.castPickRay(canvasPosition, area);
    }

    @Override
    public void takeScreenshot(File screenshotFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRendererName() {
        TeaGraphics teaGraphics = this.graphics;
        Objects.requireNonNull(teaGraphics);
        TeaGraphics teaGraphics2 = teaGraphics;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HtmlCanvasGraphics.class, PixiGraphics.class, ThreeGraphics.class}, (Object)teaGraphics2, n)) {
            case 0 -> {
                HtmlCanvasGraphics canvas = (HtmlCanvasGraphics)teaGraphics2;
                yield "HTML5 Canvas renderer";
            }
            case 1 -> {
                PixiGraphics pixi = (PixiGraphics)teaGraphics2;
                yield "Pixi.js renderer";
            }
            case 2 -> {
                ThreeGraphics three = (ThreeGraphics)teaGraphics2;
                yield "Three.js renderer";
            }
            default -> "TeaVM renderer";
        };
    }

    @Override
    public boolean isSupported(GraphicsMode graphicsMode) {
        return this.graphics.getGraphicsMode() == graphicsMode;
    }

    @Override
    @Generated
    public RenderConfig getConfig() {
        return this.config;
    }

    @Generated
    public TeaGraphics getGraphics() {
        return this.graphics;
    }

    @Override
    @Generated
    public TeaInputDevice getInput() {
        return this.input;
    }

    @Override
    @Generated
    public TeaMediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    @Generated
    public TeaNetwork getNetwork() {
        return this.network;
    }

    @Override
    @Generated
    public SceneManager getSceneManager() {
        return this.sceneManager;
    }

    @Override
    @Generated
    public Stage getStage() {
        return this.stage;
    }
}

