/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.colorize.multimedialib.stage.Image;

public class Animation {
    private List<Frame> frames;
    private boolean loop;

    private Animation(List<Frame> frames, boolean loop) {
        this.frames = new ArrayList<Frame>(frames);
        this.loop = loop;
    }

    public Animation(boolean loop) {
        this.frames = new ArrayList<Frame>();
        this.loop = loop;
    }

    public Animation(List<Image> frames, float frameTime, boolean loop) {
        this(loop);
        for (Image frame : frames) {
            this.addFrame(frame, frameTime);
        }
    }

    public Animation(Image frame) {
        this(false);
        this.addFrame(frame, 0.0f);
    }

    public void addFrame(Image frame, float frameTime) {
        Preconditions.checkNotNull((Object)frame, (Object)"Missing frame graphics");
        Preconditions.checkArgument((frameTime >= 0.0f ? 1 : 0) != 0, (Object)("Invalid frame time: " + frameTime));
        this.frames.add(new Frame(frame, frameTime));
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public List<Image> getFrameImages() {
        return this.frames.stream().map(frame -> frame.image).toList();
    }

    public Image getFrameAtIndex(int index) {
        return this.frames.get((int)index).image;
    }

    public Image getFrameAtTime(float time) {
        Preconditions.checkState((!this.frames.isEmpty() ? 1 : 0) != 0, (Object)"Animation does not contain any frames");
        if (this.frames.size() == 1) {
            return this.frames.getFirst().image;
        }
        if (this.loop) {
            time %= this.getDuration();
        }
        for (Frame frame : this.frames) {
            if (!((time -= frame.frameTime) < 0.0f)) continue;
            return frame.image;
        }
        return this.frames.getLast().image;
    }

    public float getDuration() {
        if (this.frames.size() <= 1) {
            return 0.0f;
        }
        float duration = 0.0f;
        for (Frame frame : this.frames) {
            duration += frame.frameTime;
        }
        return duration;
    }

    public void setFrameTime(int index, float frameTime) {
        Frame frame = this.frames.get(index);
        this.frames.set(index, new Frame(frame.image, frameTime));
    }

    public void setFrameTimes(List<Float> frameTimes) {
        Preconditions.checkArgument((frameTimes.size() == 1 || frameTimes.size() == this.frames.size() ? 1 : 0) != 0, (Object)("Animation has " + this.frames.size() + " frame, but provided " + frameTimes.size()));
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = this.frames.get(i);
            float time = frameTimes.get(frameTimes.size() == 1 ? 0 : i).floatValue();
            this.frames.set(i, new Frame(frame.image, time));
        }
    }

    public void setFrameTime(float frameTime) {
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = this.frames.get(i);
            this.frames.set(i, new Frame(frame.image, frameTime));
        }
    }

    public float getFrameTime(int index) {
        return this.frames.get((int)index).frameTime;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public Animation copy() {
        return new Animation(this.copyFrames(), this.loop);
    }

    private List<Frame> copyFrames() {
        return this.frames.stream().map(frame -> new Frame(frame.image, frame.frameTime)).toList();
    }

    public Animation reverse() {
        ArrayList<Frame> reverseFrames = new ArrayList<Frame>();
        reverseFrames.addAll(this.copyFrames());
        Collections.reverse(reverseFrames);
        return new Animation(reverseFrames, this.loop);
    }

    public Animation append(Animation other) {
        ArrayList<Frame> combinedFrames = new ArrayList<Frame>();
        combinedFrames.addAll(this.copyFrames());
        combinedFrames.addAll(other.copyFrames());
        return new Animation(combinedFrames, this.loop);
    }

    public Animation repeat(int times) {
        Preconditions.checkArgument((times >= 2 ? 1 : 0) != 0, (Object)"Must repeat at least twice");
        ArrayList<Frame> repeatingFrames = new ArrayList<Frame>();
        for (int i = 0; i < times; ++i) {
            repeatingFrames.addAll(this.copyFrames());
        }
        return new Animation(repeatingFrames, this.loop);
    }

    public Animation mirror() {
        return this.append(this.reverse());
    }

    private record Frame(Image image, float frameTime) {
        public Frame {
            Preconditions.checkNotNull((Object)image, (Object)"Missing frame image");
            Preconditions.checkArgument((frameTime >= 0.0f ? 1 : 0) != 0, (Object)("Invalid frame time: " + frameTime));
        }
    }
}

