/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.util.ResourceFile;

public record FontFace(ResourceFile origin, String family, int size, ColorRGB color) {
    public FontFace {
        Preconditions.checkArgument((!family.isEmpty() ? 1 : 0) != 0, (Object)"Missing font family");
        Preconditions.checkArgument((size >= 1 ? 1 : 0) != 0, (Object)"Invalid font size");
    }

    public FontFace derive(int size) {
        return new FontFace(this.origin, this.family, size, this.color);
    }

    public FontFace derive(ColorRGB color) {
        return new FontFace(this.origin, this.family, this.size, color);
    }

    public FontFace scale(Canvas canvas) {
        int actualDisplaySize = Math.round(canvas.getZoomLevel() * (float)this.size);
        return this.derive(actualDisplaySize);
    }

    @Override
    public String toString() {
        return this.family;
    }
}

