/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import lombok.Generated;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.StageNode3D;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.util.SubscribableCollection;

public class Group
implements StageNode3D,
Iterable<StageNode3D> {
    private String name;
    private SubscribableCollection<StageNode3D> children;
    private Transform3D transform;
    private Transform3D globalTransform;

    public Group(String name) {
        this.name = name;
        this.children = SubscribableCollection.wrap(new ArrayList());
        this.transform = new Transform3D();
        this.globalTransform = new Transform3D();
    }

    public Group() {
        this("Group");
    }

    public void addChild(StageNode3D child) {
        Preconditions.checkArgument((this != child ? 1 : 0) != 0, (Object)"Cannot attach group to itself");
        this.children.add((Object)child);
    }

    public Group addChildGroup() {
        Group child = new Group();
        this.addChild(child);
        return child;
    }

    public void removeChild(StageNode3D child) {
        this.children.remove((Object)child);
    }

    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public void animate(Timer animationTimer) {
    }

    @Override
    public Iterator<StageNode3D> iterator() {
        return this.children.iterator();
    }

    public String toString() {
        return String.format("%s [%d]", this.name, this.children.size());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Transform3D getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public Transform3D getGlobalTransform() {
        return this.globalTransform;
    }

    @Generated
    protected SubscribableCollection<StageNode3D> getChildren() {
        return this.children;
    }
}

