/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import lombok.Generated;
import nl.colorize.multimedialib.math.Angle;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.util.stats.Aggregate;

public final class Transform {
    private boolean visible = true;
    private Point2D position = new Point2D(0.0f, 0.0f);
    private Angle rotation = Angle.ORIGIN;
    private float scaleX = 100.0f;
    private float scaleY = 100.0f;
    private boolean flipHorizontal = false;
    private boolean flipVertical = false;
    private float alpha = 100.0f;
    private ColorRGB maskColor = null;

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setPosition(float x, float y) {
        this.setPosition(new Point2D(x, y));
    }

    public void setX(float x) {
        this.setPosition(new Point2D(x, this.position.y()));
    }

    public void setY(float y) {
        this.setPosition(new Point2D(this.position.x(), y));
    }

    public void addPosition(float deltaX, float deltaY) {
        this.setPosition(this.position.move(deltaX, deltaY));
    }

    public float getX() {
        return this.position.x();
    }

    public float getY() {
        return this.position.y();
    }

    public void setRotation(Angle rotation) {
        this.rotation = rotation;
    }

    public void setRotation(float degrees) {
        this.setRotation(new Angle(degrees));
    }

    public void addRotation(float degrees) {
        this.setRotation(this.rotation.move(degrees));
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public void setScaleX(float scaleX) {
        this.scaleX = Math.abs(scaleX);
    }

    public float getScaleX() {
        return this.flipHorizontal ? -this.scaleX : this.scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = Math.abs(scaleY);
    }

    public float getScaleY() {
        return this.flipVertical ? -this.scaleY : this.scaleY;
    }

    public void setAlpha(float alpha) {
        this.alpha = Math.clamp(alpha, 0.0f, 100.0f);
    }

    public void set(Transform other) {
        this.setVisible(other.visible);
        this.setPosition(other.position.x(), other.position.y());
        this.setRotation(other.rotation.degrees());
        this.setScaleX(other.scaleX);
        this.setScaleY(other.scaleY);
        this.setFlipHorizontal(other.flipHorizontal);
        this.setFlipVertical(other.flipVertical);
        this.setAlpha(other.alpha);
        this.setMaskColor(other.maskColor);
    }

    public Transform combine(Transform other) {
        Transform combined = new Transform();
        combined.setVisible(this.visible && other.visible);
        combined.setPosition(this.position.move(other.position));
        combined.setRotation(this.rotation.degrees() + other.rotation.degrees());
        combined.setScaleX(Aggregate.multiplyPercentage((float)this.scaleX, (float)other.scaleX));
        combined.setScaleY(Aggregate.multiplyPercentage((float)this.scaleY, (float)other.scaleY));
        combined.setFlipHorizontal(this.flipHorizontal || other.flipHorizontal);
        combined.setFlipVertical(this.flipVertical || other.flipVertical);
        combined.setAlpha(Aggregate.multiplyPercentage((float)this.alpha, (float)other.alpha));
        combined.setMaskColor(this.maskColor != null ? this.maskColor : other.maskColor);
        return combined;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    public Point2D getPosition() {
        return this.position;
    }

    @Generated
    public Angle getRotation() {
        return this.rotation;
    }

    @Generated
    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    @Generated
    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    @Generated
    public float getAlpha() {
        return this.alpha;
    }

    @Generated
    public ColorRGB getMaskColor() {
        return this.maskColor;
    }

    @Generated
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
    }

    @Generated
    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    @Generated
    public void setMaskColor(ColorRGB maskColor) {
        this.maskColor = maskColor;
    }
}

