/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;

public record Box(float x, float y, float z, float width, float height, float depth) implements Shape3D
{
    public Box {
        Preconditions.checkArgument((width >= 0.0f ? 1 : 0) != 0, (Object)("Invalid width: " + width));
        Preconditions.checkArgument((height >= 0.0f ? 1 : 0) != 0, (Object)("Invalid height: " + height));
        Preconditions.checkArgument((depth >= 0.0f ? 1 : 0) != 0, (Object)("Invalid depth: " + depth));
    }

    public float getEndX() {
        return this.x + this.width;
    }

    public float getEndY() {
        return this.y + this.height;
    }

    public float getEndZ() {
        return this.z + this.depth;
    }

    @Override
    public Box getBoundingBox() {
        return this;
    }

    @Override
    public Point3D getCenter() {
        return new Point3D(this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.z + this.depth / 2.0f);
    }

    @Override
    public boolean contains(Point3D point) {
        return point.x() >= this.x && point.x() <= this.x + this.width && point.y() >= this.y && point.y() <= this.y + this.height && point.z() >= this.z && point.z() <= this.z + this.depth;
    }

    public boolean contains(Box other) {
        return other.x >= this.x && other.x + other.width <= this.x + this.width && other.y >= this.y && other.y + other.height <= this.y + this.height && other.z >= this.z && other.z + other.depth <= this.z + this.depth;
    }

    public boolean intersects(Box other) {
        boolean outside = other.x + other.width < this.x || other.x > this.x + this.width || other.y + other.height < this.y || other.y > this.y + this.height || other.z + other.depth < this.z || other.z > this.z + this.depth;
        return !outside;
    }

    @Override
    public Box reposition(Point3D offset) {
        return new Box(this.x + offset.x(), this.y + offset.y(), this.z + offset.z(), this.width, this.height, this.depth);
    }

    public Box combine(Box other) {
        return Box.fromPoints(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z), Math.max(this.getEndX(), other.getEndX()), Math.max(this.getEndY(), other.getEndY()), Math.max(this.getEndZ(), other.getEndZ()));
    }

    @Override
    public String toString() {
        return String.format("(%d, %d, %d, %d, %d, %d)", Math.round(this.x), Math.round(this.y), Math.round(this.z), Math.round(this.width), Math.round(this.height), Math.round(this.depth));
    }

    public static Box fromPoints(float x0, float y0, float z0, float x1, float y1, float z1) {
        return new Box(x0, y0, z0, x1 - x0, y1 - y0, z1 - z0);
    }

    public static Box around(Point3D center, float width, float height, float depth) {
        return new Box(center.x() - width / 2.0f, center.y() - height / 2.0f, center.z() - depth / 2.0f, width, height, depth);
    }

    public static Box aroundOrigin(float width, float height, float depth) {
        return Box.around(Point3D.ORIGIN, width, height, depth);
    }
}

