/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.List;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Shape;

public record Rect(float x, float y, float width, float height) implements Shape
{
    public Rect {
        Preconditions.checkArgument((width >= 0.0f ? 1 : 0) != 0, (String)"Invalid width: %s", (Object)Float.valueOf(width));
        Preconditions.checkArgument((height >= 0.0f ? 1 : 0) != 0, (String)"Invalid height: %s", (Object)Float.valueOf(height));
    }

    public float getEndX() {
        return this.x + this.width;
    }

    public float getEndY() {
        return this.y + this.height;
    }

    public float getCenterX() {
        return this.x + this.width / 2.0f;
    }

    public float getCenterY() {
        return this.y + this.height / 2.0f;
    }

    @Override
    public Point2D getCenter() {
        return new Point2D(this.getCenterX(), this.getCenterY());
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    public boolean contains(float px, float py) {
        return px >= this.x && px <= this.x + this.width && py >= this.y && py <= this.y + this.height;
    }

    public boolean contains(Rect other) {
        return other.x >= this.x && other.x + other.width <= this.x + this.width && other.y >= this.y && other.y + other.height <= this.y + this.height;
    }

    public boolean intersects(Rect other) {
        boolean outside = other.x + other.width < this.x || other.x > this.x + this.width || other.y + other.height < this.y || other.y > this.y + this.height;
        return !outside;
    }

    public Rect combine(Rect other) {
        return Rect.fromPoints(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.max(this.getEndX(), other.getEndX()), Math.max(this.getEndY(), other.getEndY()));
    }

    @Override
    public Rect getBoundingBox() {
        return this;
    }

    @Override
    public Rect reposition(Point2D offset) {
        return new Rect(this.x + offset.x(), this.y + offset.y(), this.width, this.height);
    }

    public Rect expand(float amount) {
        return Rect.around(this.getCenter(), this.width + amount, this.height + amount);
    }

    public Polygon toPolygon() {
        return new Polygon(List.of(new Point2D(this.x, this.y), new Point2D(this.x + this.width, this.y), new Point2D(this.x + this.width, this.y + this.height), new Point2D(this.x, this.y + this.height)));
    }

    @Override
    public String toString() {
        return String.format("(%d, %d, %d, %d)", Math.round(this.x), Math.round(this.y), Math.round(this.width), Math.round(this.height));
    }

    public static Rect fromPoints(float x0, float y0, float x1, float y1) {
        return new Rect(x0, y0, x1 - x0, y1 - y0);
    }

    public static Rect around(float x, float y, float width, float height) {
        return Rect.around(new Point2D(x, y), width, height);
    }

    public static Rect around(Point2D center, float width, float height) {
        return new Rect(center.x() - width / 2.0f, center.y() - height / 2.0f, width, height);
    }

    public static Rect aroundOrigin(float width, float height) {
        return new Rect(-width / 2.0f, -height / 2.0f, width, height);
    }
}

