/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import lombok.Generated;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;

public class Pointer
implements Updatable {
    private final String id;
    private Point2D position;
    private int state;
    private final Timer pressedTimer;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_RELEASED = 2;

    public Pointer(String id) {
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Empty pointer ID");
        this.id = id;
        this.position = Point2D.ORIGIN;
        this.state = 0;
        this.pressedTimer = Timer.infinite();
    }

    public boolean isPressed() {
        return this.state == 1;
    }

    public boolean isPressed(Rect bounds) {
        return this.state == 1 && bounds.contains(this.position);
    }

    public boolean isReleased() {
        return this.state == 2;
    }

    public boolean isReleased(Rect bounds) {
        return this.state == 2 && bounds.contains(this.position);
    }

    public float getTimePressed() {
        return this.pressedTimer.getTime();
    }

    public void clearState() {
        this.state = 0;
        this.pressedTimer.reset();
    }

    @Override
    public void update(float deltaTime) {
        if (this.state == 1 || this.state == 2) {
            this.pressedTimer.update(deltaTime);
        } else {
            this.pressedTimer.reset();
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Point2D getPosition() {
        return this.position;
    }

    @Generated
    public int getState() {
        return this.state;
    }

    @Generated
    public Timer getPressedTimer() {
        return this.pressedTimer;
    }

    @Generated
    public void setPosition(Point2D position) {
        this.position = position;
    }

    @Generated
    public void setState(int state) {
        this.state = state;
    }
}

