/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;
import lombok.Generated;
import nl.colorize.multimedialib.math.Size;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.headless.HeadlessRenderer;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.jfx.JFXRenderer;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.renderer.teavm.HtmlCanvasGraphics;
import nl.colorize.multimedialib.renderer.teavm.PixiGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;
import nl.colorize.multimedialib.renderer.teavm.ThreeGraphics;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.util.Development;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;

public final class RenderConfig {
    private final Supplier<Renderer> launcher;
    private final GraphicsMode graphicsMode;
    private final Canvas canvas;
    private int framerate;
    private final WindowOptions windowOptions;
    private ErrorHandler errorHandler;
    private final List<Scene> globalHandlers;
    private String simulationMode;
    private static final Size SIMULATION_MODE_PHONE = new Size(350, 760);
    private static final Size SIMULATION_MODE_TABLET = new Size(570, 760);
    private static final Logger LOGGER = LogHelper.getLogger(RenderConfig.class);

    private RenderConfig(Supplier<Renderer> launcher, GraphicsMode graphicsMode, Canvas canvas) {
        this.launcher = launcher;
        this.graphicsMode = graphicsMode;
        this.canvas = canvas;
        this.framerate = 60;
        this.errorHandler = ErrorHandler.DEFAULT;
        this.windowOptions = new WindowOptions();
        this.globalHandlers = new ArrayList<Scene>();
        this.simulationMode = System.getProperty("multimedialib.simulation");
        if (Platform.isDesktopPlatform()) {
            this.globalHandlers.add(this::checkScreenshotHandler);
        }
    }

    public boolean isSimulationMode() {
        return this.simulationMode != null && !this.simulationMode.isEmpty();
    }

    public void start(Scene initialScene) {
        Renderer renderer;
        if (this.isSimulationMode()) {
            this.applySimulationMode();
        }
        if (!(renderer = this.launcher.get()).isSupported(this.graphicsMode)) {
            throw new UnsupportedOperationException("Renderer does not support graphics mode");
        }
        BootstrapScene bootstrapScene = new BootstrapScene(initialScene, this.globalHandlers);
        renderer.start(this, bootstrapScene);
    }

    private void applySimulationMode() {
        LOGGER.info("Using simulation mode '" + this.simulationMode + "'");
        Size simulationModeScreenSize = switch (this.simulationMode) {
            case "tablet", "ipad" -> SIMULATION_MODE_TABLET;
            default -> SIMULATION_MODE_PHONE;
        };
        this.windowOptions.setFullscreen(false);
        this.windowOptions.setWindowSize(simulationModeScreenSize);
    }

    private void checkScreenshotHandler(SceneContext context, float deltaTime) {
        if (context.getInput().isKeyReleased(KeyCode.F12)) {
            try {
                File screenshotFile = new File(Platform.getUserDesktopDir(), "screenshot-" + System.currentTimeMillis() + ".png");
                context.takeScreenshot(screenshotFile);
                LOGGER.info("Saved screenshot to " + screenshotFile.getAbsolutePath());
            }
            catch (UnsupportedOperationException e) {
                LOGGER.warning("Screenshots not supported");
            }
        }
    }

    public static RenderConfig forDesktop(String renderer, GraphicsMode graphicsMode, Canvas canvas) {
        Preconditions.checkState((boolean)Platform.isDesktopPlatform(), (Object)("Cannot launch desktop renderer on non-desktop platform: " + String.valueOf(Platform.getPlatform())));
        Supplier<Renderer> launcher = switch (renderer.toLowerCase()) {
            case "java2d" -> Java2DRenderer::new;
            case "libgdx", "gdx" -> GDXRenderer::new;
            case "javafx", "jfx", "openjfx" -> JFXRenderer::launch;
            default -> throw new IllegalArgumentException("Unknown desktop renderer: " + renderer);
        };
        return new RenderConfig(launcher, graphicsMode, canvas);
    }

    public static RenderConfig forBrowser(String renderer, GraphicsMode graphicsMode, Canvas canvas) {
        Preconditions.checkState((boolean)Platform.isTeaVM(), (Object)"Browser-based renderer requires TeaVM");
        Supplier<Renderer> launcher = switch (renderer.toLowerCase()) {
            case "canvas", "html5" -> () -> new TeaRenderer(new HtmlCanvasGraphics());
            case "pixi", "pixijs" -> () -> new TeaRenderer(new PixiGraphics());
            case "three", "threejs" -> () -> new TeaRenderer(new ThreeGraphics());
            default -> throw new IllegalArgumentException("Unknown browser renderer: " + renderer);
        };
        return new RenderConfig(launcher, graphicsMode, canvas);
    }

    @Development
    public static RenderConfig headless(GraphicsMode graphicsMode, Canvas canvas) {
        boolean graphicsEnv = graphicsMode != GraphicsMode.HEADLESS;
        return new RenderConfig(() -> new HeadlessRenderer(graphicsEnv), graphicsMode, canvas);
    }

    @Generated
    public Supplier<Renderer> getLauncher() {
        return this.launcher;
    }

    @Generated
    public GraphicsMode getGraphicsMode() {
        return this.graphicsMode;
    }

    @Generated
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Generated
    public int getFramerate() {
        return this.framerate;
    }

    @Generated
    public WindowOptions getWindowOptions() {
        return this.windowOptions;
    }

    @Generated
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Generated
    public List<Scene> getGlobalHandlers() {
        return this.globalHandlers;
    }

    @Generated
    public String getSimulationMode() {
        return this.simulationMode;
    }

    @Generated
    public void setFramerate(int framerate) {
        this.framerate = framerate;
    }

    @Generated
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Generated
    public void setSimulationMode(String simulationMode) {
        this.simulationMode = simulationMode;
    }

    private static class BootstrapScene
    implements Scene {
        private Scene initialScene;
        private List<Scene> globalHandlers;

        @Override
        public void start(SceneContext context) {
            for (Scene handler : this.globalHandlers) {
                context.attachGlobal(handler);
            }
            context.changeScene(this.initialScene);
        }

        @Override
        public void update(SceneContext context, float deltaTime) {
        }

        @Generated
        public BootstrapScene(Scene initialScene, List<Scene> globalHandlers) {
            this.initialScene = initialScene;
            this.globalHandlers = globalHandlers;
        }
    }
}

