/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import nl.colorize.multimedialib.math.Size;
import nl.colorize.multimedialib.renderer.Canvas;

@FunctionalInterface
public interface ScaleStrategy {
    default public float getZoomLevel(Canvas canvas) {
        Size preferredSize = canvas.getPreferredSize();
        Size screenSize = canvas.getScreenSize();
        float horizontalZoom = (float)screenSize.width() / (float)preferredSize.width();
        float verticalZoom = (float)screenSize.height() / (float)preferredSize.height();
        return this.getZoomLevel(horizontalZoom, verticalZoom);
    }

    public float getZoomLevel(float var1, float var2);

    public static ScaleStrategy flexible() {
        return (horizontalZoom, verticalZoom) -> 1.0f;
    }

    public static ScaleStrategy scale() {
        return (horizontalZoom, verticalZoom) -> Math.max(horizontalZoom, verticalZoom);
    }

    public static ScaleStrategy fit() {
        return (horizontalZoom, verticalZoom) -> Math.min(horizontalZoom, verticalZoom);
    }

    public static ScaleStrategy balanced() {
        return (horizontalZoom, verticalZoom) -> (horizontalZoom + verticalZoom) / 2.0f;
    }
}

