/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Splitter;
import java.util.List;
import nl.colorize.multimedialib.math.Coordinate;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.SpriteAtlas;
import nl.colorize.util.ResourceFile;

public class SpriteAtlasLoader {
    private MediaLoader mediaLoader;
    private static final Splitter COORDINATE_SPLITTER = Splitter.on((String)",").trimResults();

    protected SpriteAtlasLoader(MediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
    }

    protected SpriteAtlas load(ResourceFile file) {
        if (!file.getName().endsWith(".atlas")) {
            throw new MediaException("Provided file is not a sprite atlas: " + String.valueOf(file));
        }
        ParserState state = new ParserState();
        state.file = file;
        state.atlas = new SpriteAtlas();
        state.reset();
        for (String line : this.mediaLoader.loadTextLines(file)) {
            if (line.isEmpty()) continue;
            this.parseLine(line, state);
        }
        return state.atlas;
    }

    private void parseLine(String line, ParserState state) {
        if (line.endsWith(".png")) {
            state.currentImage = this.loadImage(state.file, line);
        } else if (this.countIndent(line) == 0) {
            state.name = line;
        } else if (line.trim().startsWith("xy:")) {
            state.xy = this.parsePropertyValue(line);
        } else if (line.trim().startsWith("size:")) {
            state.size = this.parsePropertyValue(line);
            if (state.isReady()) {
                this.flushEntry(state);
            }
        }
    }

    private int countIndent(String line) {
        int indent = 0;
        for (int i = 0; i < Math.min(line.length(), 80); ++i) {
            if (line.charAt(i) == ' ') {
                ++indent;
                continue;
            }
            if (line.charAt(i) != '\t') continue;
            indent += 4;
        }
        return indent;
    }

    private void flushEntry(ParserState state) {
        Region region = new Region(state.xy.x(), state.xy.y(), state.size.x(), state.size.y());
        state.atlas.add(state.name, state.currentImage, region);
        state.reset();
    }

    private Image loadImage(ResourceFile origin, String name) {
        ResourceFile imageFile = origin.sibling(name);
        return this.mediaLoader.loadImage(imageFile);
    }

    private Coordinate parsePropertyValue(String line) {
        String value = line.substring(line.indexOf(":") + 1);
        List parts = COORDINATE_SPLITTER.splitToList((CharSequence)value);
        return new Coordinate(Integer.parseInt((String)parts.get(0)), Integer.parseInt((String)parts.get(1)));
    }

    private static class ParserState {
        private ResourceFile file;
        private SpriteAtlas atlas;
        private Image currentImage;
        private String name;
        private Coordinate xy;
        private Coordinate size;

        private ParserState() {
        }

        public boolean isReady() {
            return this.name != null && this.currentImage != null && this.xy != null && this.size != null;
        }

        public void reset() {
            this.name = null;
            this.xy = null;
            this.size = null;
        }
    }
}

