/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.Application;
import javax.swing.SwingUtilities;
import lombok.Generated;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.renderer.jfx.JFXAnimationLoop;
import nl.colorize.multimedialib.renderer.jfx.JFXGraphics;
import nl.colorize.multimedialib.renderer.jfx.JFXInput;
import nl.colorize.multimedialib.renderer.jfx.JFXMediaLoader;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.util.swing.SwingUtils;

public class JFXRenderer
implements Renderer,
SceneContext {
    private RenderConfig config;
    private JFXGraphics graphics;
    private JFXInput input;
    private JFXMediaLoader mediaLoader;
    private Network network;
    private SceneManager sceneManager;
    private Stage stage;
    private List<File> screenshotQueue = new CopyOnWriteArrayList<File>();
    private static JFXRenderer instance;

    private JFXRenderer() {
    }

    @Override
    public void start(RenderConfig config, Scene initialScene) {
        SwingUtilities.invokeLater(SwingUtils::initializeSwing);
        this.config = config;
        this.mediaLoader = new JFXMediaLoader();
        this.network = new StandardNetwork();
        this.input = new JFXInput(config.getCanvas());
        this.graphics = new JFXGraphics(config, this.mediaLoader);
        this.sceneManager = new SceneManager();
        this.stage = new Stage(config.getGraphicsMode(), config.getCanvas());
        this.changeScene(initialScene);
        Application.launch(JFXAnimationLoop.class, (String[])new String[0]);
    }

    @Override
    public void terminate() {
        System.exit(0);
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2D project(Point3D position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void takeScreenshot(File screenshotFile) {
        this.screenshotQueue.add(screenshotFile);
    }

    @Override
    public String getRendererName() {
        return "JavaFX renderer";
    }

    @Override
    public boolean isSupported(GraphicsMode graphicsMode) {
        return graphicsMode == GraphicsMode.MODE_2D;
    }

    public static synchronized JFXRenderer launch() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Another JFXRenderer instance is already active");
        instance = new JFXRenderer();
        return instance;
    }

    protected static synchronized JFXRenderer accessInstance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"JFXRenderer has not yet been initialized");
        Preconditions.checkState((JFXRenderer.instance.config != null ? 1 : 0) != 0, (Object)"JFXRenderer not yet initialized");
        return instance;
    }

    @Override
    @Generated
    public RenderConfig getConfig() {
        return this.config;
    }

    @Generated
    public JFXGraphics getGraphics() {
        return this.graphics;
    }

    @Override
    @Generated
    public JFXInput getInput() {
        return this.input;
    }

    @Override
    @Generated
    public JFXMediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    @Generated
    public Network getNetwork() {
        return this.network;
    }

    @Override
    @Generated
    public SceneManager getSceneManager() {
        return this.sceneManager;
    }

    @Override
    @Generated
    public Stage getStage() {
        return this.stage;
    }

    @Generated
    public List<File> getScreenshotQueue() {
        return this.screenshotQueue;
    }
}

