/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXModel;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Group;
import nl.colorize.multimedialib.stage.Light;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageNode3D;
import nl.colorize.multimedialib.stage.StageSubscriber;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.util.stats.Cache;

public class GDXGraphics
implements StageVisitor,
StageSubscriber {
    private GraphicsMode graphicsMode;
    private Canvas canvas;
    private GDXMediaLoader mediaLoader;
    private SpriteBatch spriteBatch;
    private ShapeRenderer shapeBatch;
    private Cache<MaskTexture, TextureRegion> maskCache;
    protected PerspectiveCamera camera;
    private Environment environment;
    private Map<Light, PointLight> lights;
    private ModelBatch modelBatch;
    private List<ModelInstance> displayList;
    private static final int FIELD_OF_VIEW = 75;
    private static final float NEAR_PLANE = 1.0f;
    private static final float FAR_PLANE = 300.0f;
    private static final int CIRCLE_SEGMENTS = 32;
    private static final int MASK_CACHE_SIZE = 1024;

    protected GDXGraphics(GraphicsMode graphicsMode, Canvas canvas, GDXMediaLoader mediaLoader) {
        this.graphicsMode = graphicsMode;
        this.canvas = canvas;
        this.mediaLoader = mediaLoader;
        this.maskCache = Cache.from(this::createMask, (int)1024);
        this.camera = new PerspectiveCamera(75.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.camera.near = 1.0f;
        this.camera.far = 300.0f;
        this.camera.update();
        this.environment = new Environment();
        this.lights = new HashMap<Light, PointLight>();
        this.restartBatch();
    }

    protected void restartBatch() {
        this.spriteBatch = new SpriteBatch();
        this.shapeBatch = new ShapeRenderer();
        this.modelBatch = new ModelBatch();
        if (this.displayList != null) {
            this.displayList.clear();
        }
    }

    @Override
    public void prepareStage(Stage stage) {
        if (this.displayList == null) {
            this.displayList = new ArrayList<ModelInstance>();
            stage.subscribe(this);
        }
        if (this.graphicsMode == GraphicsMode.MODE_3D) {
            this.camera.position.set(this.toVector(stage.getCameraPosition()));
            this.camera.up.set(0.0f, 1.0f, 0.0f);
            this.camera.lookAt(this.toVector(stage.getCameraFocus()));
            this.camera.update();
            Color ambient = GDXMediaLoader.toColor(stage.getAmbientLightColor());
            this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, ambient));
            this.displayList.clear();
        }
    }

    @Override
    public void onNodeAdded(Group parent, StageNode3D node) {
        if (node instanceof Light) {
            Light light = (Light)node;
            PointLight gdxLight = new PointLight();
            this.environment.add(gdxLight);
            this.lights.put(light, gdxLight);
        }
    }

    @Override
    public void onNodeRemoved(Group parent, StageNode3D node) {
        if (node instanceof Light) {
            Light light = (Light)node;
            PointLight gdxLight = this.lights.get(light);
            this.environment.remove(gdxLight);
            this.lights.remove(light);
        }
    }

    @Override
    public boolean shouldVisitAllNodes() {
        return false;
    }

    @Override
    public void visitContainer(Container container, Transform globalTransform) {
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(backgroundColor));
        this.shapeBatch.rect(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.switchMode(false, false);
    }

    private Color getPrimitiveColor(Primitive primitive, Transform globalTransform) {
        ColorRGB color = globalTransform.getMaskColor();
        if (color == null) {
            color = primitive.getColor();
        }
        return this.convertColor(color, globalTransform.getAlpha());
    }

    @Override
    public void drawLine(Primitive graphic, Line line, Transform globalTransform) {
        Color color = this.getPrimitiveColor(graphic, globalTransform);
        if (graphic.getStroke() == 1.0f) {
            this.drawBasicLines(List.of(line), color);
        } else {
            this.drawComplexLines(List.of(line), color, graphic.getStroke());
        }
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line, Transform globalTransform) {
        Color color = this.getPrimitiveColor(graphic, globalTransform);
        if (graphic.getStroke() == 1.0f) {
            this.drawBasicLines(line.getSegments(), color);
        } else {
            this.drawComplexLines(line.getSegments(), color, graphic.getStroke());
        }
    }

    private void drawBasicLines(List<Line> lines, Color color) {
        this.switchMode(false, false);
        Gdx.gl.glEnable(3042);
        this.shapeBatch.begin(ShapeRenderer.ShapeType.Line);
        this.shapeBatch.setColor(color);
        for (Line segment : lines) {
            float x0 = this.toScreenX(segment.start().x());
            float y0 = this.toScreenY(segment.start().y());
            float x1 = this.toScreenX(segment.end().x());
            float y1 = this.toScreenY(segment.end().y());
            this.shapeBatch.line(x0, y0, x1, y1);
        }
        this.shapeBatch.end();
    }

    private void drawComplexLines(List<Line> lines, Color color, float stroke) {
        this.switchMode(false, false);
        Gdx.gl.glEnable(3042);
        this.shapeBatch.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeBatch.setColor(color);
        for (Line segment : lines) {
            float x0 = this.toScreenX(segment.start().x());
            float y0 = this.toScreenY(segment.start().y());
            float x1 = this.toScreenX(segment.end().x());
            float y1 = this.toScreenY(segment.end().y());
            this.shapeBatch.rectLine(new Vector2(x0, y0), new Vector2(x1, y1), stroke);
        }
        this.shapeBatch.end();
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect, Transform globalTransform) {
        float x = this.toScreenX(rect.x());
        float y = this.toScreenY(rect.getEndY());
        float width = rect.width() * this.canvas.getZoomLevel();
        float height = rect.height() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.getPrimitiveColor(graphic, globalTransform));
        this.shapeBatch.rect(x, y, width, height);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle, Transform globalTransform) {
        float x = this.toScreenX(circle.center().x());
        float y = this.toScreenY(circle.center().y());
        float radius = circle.radius() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.getPrimitiveColor(graphic, globalTransform));
        this.shapeBatch.circle(x, y, radius, 32);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon, Transform globalTransform) {
        Color color = this.getPrimitiveColor(graphic, globalTransform);
        if (polygon.getNumPoints() == 3) {
            this.drawTriangle(polygon.toPoints(), color);
        } else {
            for (Polygon triangle : polygon.subdivide()) {
                this.drawTriangle(triangle.toPoints(), color);
            }
        }
    }

    private void drawTriangle(float[] vertices, Color color) {
        this.switchMode(false, true);
        this.shapeBatch.setColor(color);
        this.shapeBatch.triangle(this.toScreenX(vertices[0]), this.toScreenY(vertices[1]), this.toScreenX(vertices[2]), this.toScreenY(vertices[3]), this.toScreenX(vertices[4]), this.toScreenY(vertices[5]));
    }

    @Override
    public void drawSprite(Sprite sprite, Transform globalTransform) {
        TextureRegion textureRegion = ((GDXImage)sprite.getCurrentGraphics()).getTextureRegion();
        this.drawSprite(textureRegion, globalTransform);
    }

    private void drawSprite(TextureRegion textureRegion, Transform transform) {
        float screenX = this.toScreenX(transform.getPosition().x());
        float screenY = this.toScreenY(transform.getPosition().y());
        float screenWidth = (float)textureRegion.getRegionWidth() * this.canvas.getZoomLevel();
        float screenHeight = (float)textureRegion.getRegionHeight() * this.canvas.getZoomLevel();
        if (transform.getMaskColor() != null) {
            textureRegion = (TextureRegion)this.maskCache.get((Object)new MaskTexture(textureRegion, transform.getMaskColor()));
        }
        this.switchMode(true, false);
        this.spriteBatch.setColor(1.0f, 1.0f, 1.0f, transform.getAlpha() / 100.0f);
        this.spriteBatch.draw(textureRegion, screenX - screenWidth / 2.0f, screenY - screenHeight / 2.0f, screenWidth / 2.0f, screenHeight / 2.0f, screenWidth, screenHeight, transform.getScaleX() / 100.0f, transform.getScaleY() / 100.0f, -transform.getRotation().degrees());
    }

    private TextureRegion createMask(MaskTexture config) {
        TextureRegion original = config.original;
        TextureData textureData = original.getTexture().getTextureData();
        textureData.prepare();
        Pixmap pixels = textureData.consumePixmap();
        Pixmap mask = new Pixmap(original.getRegionWidth(), original.getRegionHeight(), Pixmap.Format.RGBA8888);
        for (int x = 0; x < original.getRegionWidth(); ++x) {
            for (int y = 0; y < original.getRegionHeight(); ++y) {
                int rgba = pixels.getPixel(original.getRegionX() + x, original.getRegionY() + y);
                int maskRGBA = Color.rgba8888((Color)this.convertColor(config.color, new Color((int)rgba).a * 100.0f));
                mask.drawPixel(x, y, maskRGBA);
            }
        }
        Texture texture = new Texture(mask);
        pixels.dispose();
        mask.dispose();
        return new TextureRegion(texture);
    }

    @Override
    public void drawText(Text text, Transform globalTransform) {
        FontFace scaledFont = text.getFont().scale(this.canvas);
        BitmapFont bitmapFont = this.mediaLoader.getBitmapFont(scaledFont);
        float screenX = this.toScreenX(globalTransform.getPosition().x());
        int align = this.getTextAlign(text.getAlign());
        float ascent = 0.8f * (float)text.getFont().size();
        this.switchMode(true, false);
        text.forLines((i, line) -> {
            float lineY = globalTransform.getPosition().y() + (float)i.intValue() * text.getLineHeight() - ascent;
            float screenY = this.toScreenY(lineY);
            bitmapFont.draw((Batch)this.spriteBatch, (CharSequence)line, screenX, screenY, 0.0f, align, false);
        });
    }

    private int getTextAlign(Align align) {
        return switch (align) {
            default -> throw new MatchException(null, null);
            case Align.LEFT -> 8;
            case Align.CENTER -> 1;
            case Align.RIGHT -> 16;
        };
    }

    @Override
    public void finalize2D(Stage stage) {
        this.switchMode(false, false);
    }

    @Override
    public void visitGroup(Group group, Transform3D globalTransform) {
    }

    @Override
    public void drawMesh(Mesh mesh, Transform3D globalTransform) {
        if (globalTransform.isVisible()) {
            GDXModel gdxModel = (GDXModel)mesh;
            this.syncTransform(gdxModel.getModelInstance(), globalTransform);
            this.displayList.add(gdxModel.getModelInstance());
        }
    }

    private void syncTransform(ModelInstance modelInstance, Transform3D globalTransform) {
        Vector3 positionVector = this.convertVector(globalTransform.getPosition());
        modelInstance.transform.setToTranslation(positionVector);
        modelInstance.transform.rotate(1.0f, 0.0f, 0.0f, globalTransform.getRotationX().degrees());
        modelInstance.transform.rotate(0.0f, 1.0f, 0.0f, globalTransform.getRotationY().degrees());
        modelInstance.transform.rotate(0.0f, 0.0f, 1.0f, globalTransform.getRotationZ().degrees());
        modelInstance.transform.scale(globalTransform.getScaleX() / 100.0f, globalTransform.getScaleY() / 100.0f, globalTransform.getScaleZ() / 100.0f);
    }

    @Override
    public void drawLight(Light light, Transform3D globalTransform) {
        PointLight gdxLight = this.lights.get(light);
        gdxLight.setColor(this.convertColor(light.getColor()));
        gdxLight.setPosition(this.convertVector(globalTransform.getPosition()));
        gdxLight.setIntensity(globalTransform.isVisible() ? light.getIntensity() : 0.0f);
    }

    @Override
    public void finalize3D(Stage stage) {
        if (this.graphicsMode == GraphicsMode.MODE_3D) {
            this.modelBatch.begin((Camera)this.camera);
            this.modelBatch.render(this.displayList, this.environment);
            this.modelBatch.end();
        }
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    public float toScreenY(float y) {
        return (float)Gdx.graphics.getHeight() - this.canvas.toScreenY(y);
    }

    private Color convertColor(ColorRGB color, float alpha) {
        return new Color((float)color.r() / 255.0f, (float)color.g() / 255.0f, (float)color.b() / 255.0f, alpha / 100.0f);
    }

    private Color convertColor(ColorRGB color) {
        return this.convertColor(color, 100.0f);
    }

    private Vector3 convertVector(Point3D point) {
        return new Vector3(point.x(), point.y(), point.z());
    }

    private void switchMode(boolean sprites, boolean shapes) {
        Preconditions.checkArgument((!sprites || !shapes ? 1 : 0) != 0, (Object)"Invalid drawing mode");
        if (sprites) {
            this.endShapeBatch();
            this.beginSpriteBatch();
        } else if (shapes) {
            this.endSpriteBatch();
            this.beginShapeBatch();
        } else {
            this.endSpriteBatch();
            this.endShapeBatch();
        }
    }

    private void beginSpriteBatch() {
        if (!this.spriteBatch.isDrawing()) {
            this.spriteBatch.begin();
        }
    }

    private void endSpriteBatch() {
        if (this.spriteBatch.isDrawing()) {
            this.spriteBatch.end();
        }
    }

    private void beginShapeBatch() {
        if (!this.shapeBatch.isDrawing()) {
            Gdx.gl.glEnable(3042);
            this.shapeBatch.begin(ShapeRenderer.ShapeType.Filled);
        }
    }

    private void endShapeBatch() {
        if (this.shapeBatch.isDrawing()) {
            this.shapeBatch.end();
        }
    }

    private Vector3 toVector(Point3D point) {
        return new Vector3(point.x(), point.y(), point.z());
    }

    protected void dispose() {
        this.endSpriteBatch();
        this.endShapeBatch();
        this.spriteBatch.dispose();
        this.shapeBatch.dispose();
        this.modelBatch.dispose();
    }

    private record MaskTexture(TextureRegion original, ColorRGB color) {
    }
}

