/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import nl.colorize.multimedialib.renderer.PeerConnection;
import nl.colorize.multimedialib.renderer.teavm.MessageCallback;
import nl.colorize.multimedialib.renderer.teavm.PeerMessage;
import nl.colorize.multimedialib.renderer.teavm.PeerjsBridge;
import nl.colorize.util.SubscribableCollection;

public class PeerjsConnection
implements PeerConnection,
MessageCallback {
    private PeerjsBridge bridge;
    private SubscribableCollection<String> connectionQueue;
    private SubscribableCollection<PeerMessage> receivedBuffer;
    private List<String> sendHistory;

    protected PeerjsConnection(PeerjsBridge bridge) {
        this.bridge = bridge;
        this.connectionQueue = SubscribableCollection.wrap(new CopyOnWriteArrayList());
        this.receivedBuffer = SubscribableCollection.wrap(new CopyOnWriteArrayList());
        this.sendHistory = new ArrayList<String>();
        bridge.open(this);
    }

    @Override
    public void connect(String peerId) {
        this.connectionQueue.add((Object)peerId);
        this.processConnectionQueue();
    }

    private void processConnectionQueue() {
        if (this.bridge.isInitialized()) {
            this.connectionQueue.flush().forEach(peerId -> this.bridge.connect((String)peerId, this));
        }
    }

    @Override
    public void sendMessage(String message) {
        this.bridge.sendMessage(message);
        this.sendHistory.add(message);
    }

    @Override
    public Iterable<PeerMessage> flushReceivedMessages() {
        Stream messages = this.receivedBuffer.flush();
        return messages::iterator;
    }

    @Override
    public void onMessage(String type, String value) {
        this.receivedBuffer.add((Object)new PeerMessage(type, value));
        if (type.equals("init")) {
            this.processConnectionQueue();
        } else if (type.equals("connect")) {
            this.sendHistory.forEach(message -> this.bridge.sendMessageToPeer(value, (String)message));
        }
    }
}

