/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import lombok.Generated;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.BrowserBridge;
import nl.colorize.multimedialib.renderer.teavm.TeaAudio;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.ThreeBridge;
import nl.colorize.multimedialib.renderer.teavm.ThreeMeshWrapper;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.LoadStatus;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.Subject;
import nl.colorize.util.SubscribableCollection;
import nl.colorize.util.stats.Cache;
import org.teavm.jso.browser.Storage;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLAudioElement;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLImageElement;

public class TeaMediaLoader
implements MediaLoader {
    private GraphicsMode graphicsMode;
    private HTMLDocument document;
    private BrowserBridge bridge;
    private String timestamp;
    private List<ResourceFile> manifest;
    private SubscribableCollection<LoadStatus> loadStatus;
    private Cache<MaskImage, HTMLCanvasElement> maskImageCache;
    private static final ResourceFile MANIFEST_FILE = new ResourceFile("resource-file-manifest");
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults().omitEmptyStrings();
    private static final int IMAGE_CACHE_SIZE = 500;
    private static final Logger LOGGER = LogHelper.getLogger(TeaMediaLoader.class);

    protected TeaMediaLoader(GraphicsMode graphicsMode) {
        this.graphicsMode = graphicsMode;
        this.document = Window.current().getDocument();
        this.bridge = Browser.getBrowserBridge();
        this.timestamp = this.bridge.getMeta("build-id", String.valueOf(System.currentTimeMillis()));
        this.manifest = Collections.emptyList();
        this.loadStatus = SubscribableCollection.wrap(new ArrayList());
        this.maskImageCache = Cache.from(this::createMaskImage, (int)500);
    }

    @Override
    public Image loadImage(ResourceFile file) {
        HTMLImageElement imageElement = (HTMLImageElement)this.document.createElement("img");
        Subject imagePromise = new Subject();
        this.loadStatus.add((Object)LoadStatus.track(file, imagePromise));
        imageElement.setCrossOrigin("anonymous");
        imageElement.addEventListener("load", event -> imagePromise.next((Object)imageElement));
        imageElement.setSrc(this.getResourceFileURL(file));
        return new TeaImage((Subject<HTMLImageElement>)imagePromise, null);
    }

    @Override
    public Audio loadAudio(ResourceFile file) {
        HTMLAudioElement audioElement = (HTMLAudioElement)this.document.createElement("audio");
        Subject audioPromise = new Subject();
        this.loadStatus.add((Object)LoadStatus.track(file, audioPromise));
        audioElement.setCrossOrigin("anonymous");
        audioElement.addEventListener("loadeddata", event -> audioPromise.next((Object)audioElement));
        audioElement.setSrc(this.getResourceFileURL(file));
        return new TeaAudio((Subject<HTMLAudioElement>)audioPromise);
    }

    @Override
    public FontFace loadFont(ResourceFile file, String family, int size, ColorRGB color) {
        String url = "url('" + this.getResourceFileURL(file) + "')";
        Subject promise = new Subject();
        this.loadStatus.add((Object)LoadStatus.track(file, promise));
        this.bridge.preloadFontFace(family, url, error -> {
            promise.next((Object)url);
            if (error != null && !error.isEmpty()) {
                LOGGER.warning("Failed to load font '" + family + "': " + error);
            }
        });
        return new FontFace(file, family, size, color);
    }

    @Override
    public Mesh loadModel(ResourceFile file) {
        if (this.graphicsMode != GraphicsMode.MODE_3D) {
            throw new UnsupportedOperationException("Renderer does not support 3D graphics");
        }
        Subject modelPromise = new Subject();
        if (file.getName().endsWith(".gltf")) {
            Browser.getThreeBridge().loadGLTF(this.getResourceFileURL(file), arg_0 -> ((Subject)modelPromise).next(arg_0));
        } else if (file.getName().endsWith(".obj")) {
            Browser.getThreeBridge().loadOBJ(this.getResourceFileURL(file), arg_0 -> ((Subject)modelPromise).next(arg_0));
        } else {
            throw new IllegalArgumentException("Unknown model format: " + String.valueOf(file));
        }
        this.loadStatus.add((Object)LoadStatus.track(file, modelPromise));
        return new ThreeMeshWrapper((Subject<ThreeBridge.ThreeObject>)modelPromise);
    }

    @Override
    public String loadText(ResourceFile file) {
        HTMLElement resource = this.document.getElementById(this.normalizeFilePath(file, true));
        if (resource == null) {
            throw new MediaException("Unknown text resource file: " + String.valueOf(file));
        }
        return resource.getInnerText().trim();
    }

    @Override
    public boolean containsResourceFile(ResourceFile file) {
        String fileEntry = file.path().contains("/") ? file.path().substring(file.path().lastIndexOf("/") + 1) : file.path();
        return this.loadResourceFileManifest().stream().anyMatch(entry -> entry.path().equals(fileEntry));
    }

    private List<ResourceFile> loadResourceFileManifest() {
        if (!this.manifest.isEmpty()) {
            return this.manifest;
        }
        this.manifest = LINE_SPLITTER.splitToList((CharSequence)this.loadText(MANIFEST_FILE)).stream().map(path -> new ResourceFile(path)).toList();
        return this.manifest;
    }

    private String getResourceFileURL(ResourceFile file) {
        return "resources/" + this.normalizeFilePath(file, false) + "?t=" + this.timestamp;
    }

    protected String normalizeFilePath(ResourceFile file, boolean replaceDot) {
        String normalized = file.path();
        if (normalized.indexOf(47) != -1) {
            normalized = normalized.substring(normalized.lastIndexOf(47) + 1);
        }
        if (replaceDot) {
            normalized = normalized.replace(".", "_");
        }
        return normalized;
    }

    @Override
    public Properties loadApplicationData(String appName) {
        this.bridge.loadApplicationData();
        Storage localStorage = Storage.getLocalStorage();
        Properties data = new Properties();
        for (int i = 0; i < localStorage.getLength(); ++i) {
            String name = localStorage.key(i);
            String value = localStorage.getItem(name);
            data.setProperty(name, value);
        }
        return data;
    }

    @Override
    public void saveApplicationData(String appName, Properties data) {
        for (String name : data.stringPropertyNames()) {
            String value = data.getProperty(name);
            this.bridge.saveApplicationData(name, value);
        }
    }

    public HTMLCanvasElement applyMask(TeaImage image, ColorRGB mask) {
        MaskImage cacheKey = new MaskImage(image, mask);
        return (HTMLCanvasElement)this.maskImageCache.get((Object)cacheKey);
    }

    private HTMLCanvasElement createMaskImage(MaskImage key) {
        Preconditions.checkState((boolean)key.image().isLoaded(), (Object)"Image is still loading");
        HTMLImageElement img = key.image().getImageElement().get();
        HTMLCanvasElement canvas = (HTMLCanvasElement)this.document.createElement("canvas");
        canvas.setWidth(img.getWidth());
        canvas.setHeight(img.getHeight());
        CanvasRenderingContext2D maskContext = (CanvasRenderingContext2D)canvas.getContext("2d");
        maskContext.drawImage((CanvasImageSource)img, 0.0, 0.0, (double)img.getWidth(), (double)img.getHeight());
        maskContext.setGlobalCompositeOperation("source-atop");
        maskContext.setFillStyle(key.mask().toHex());
        maskContext.fillRect(0.0, 0.0, (double)img.getWidth(), (double)img.getHeight());
        return canvas;
    }

    @Override
    @Generated
    public SubscribableCollection<LoadStatus> getLoadStatus() {
        return this.loadStatus;
    }

    private record MaskImage(TeaImage image, ColorRGB mask) {
    }
}

