/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import lombok.Generated;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.ThreeBridge;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.util.Subject;
import org.teavm.jso.dom.html.HTMLImageElement;

public class ThreeMeshWrapper
implements Mesh {
    private Subject<ThreeBridge.ThreeObject> meshPromise;
    private ThreeBridge.ThreeObject threeObject;
    private Transform3D transform;
    private Transform3D globalTransform;
    private Sprite dynamicTexture;

    public ThreeMeshWrapper(Subject<ThreeBridge.ThreeObject> meshPromise) {
        this.meshPromise = meshPromise;
        this.transform = new Transform3D();
        this.globalTransform = new Transform3D();
        meshPromise.subscribe(event -> {
            this.threeObject = event;
        });
    }

    @Override
    public void animate(Timer animationTimer) {
        if (this.dynamicTexture != null) {
            this.dynamicTexture.animate(animationTimer);
            TeaImage image = (TeaImage)this.dynamicTexture.getCurrentGraphics();
            if (this.threeObject != null && image.getImageElement().isPresent()) {
                this.applyTexture(image);
            }
        }
    }

    @Override
    public void applyColor(ColorRGB color) {
        ThreeBridge threeBridge = Browser.getThreeBridge();
        if (this.threeObject == null) {
            this.meshPromise.subscribe(model -> threeBridge.applyColor((ThreeBridge.ThreeObject)model, color.toHex()));
        } else {
            threeBridge.applyColor(this.threeObject, color.toHex());
        }
    }

    @Override
    public void applyTexture(Image texture) {
        TeaImage teaImage = (TeaImage)texture;
        Region region = teaImage.getRegion();
        if (teaImage.getImageElement().isPresent()) {
            this.applyTexture(teaImage.getImageElement().get(), region);
        } else {
            teaImage.getImagePromise().subscribe(image -> this.applyTexture((HTMLImageElement)image, region));
        }
    }

    private void applyTexture(HTMLImageElement image, Region region) {
        int h;
        ThreeBridge threeBridge = Browser.getThreeBridge();
        int x = region.x();
        int y = region.y();
        int w = region.equals(TeaImage.IMAGE_LOADING_REGION) ? image.getWidth() : region.width();
        int n = h = region.equals(TeaImage.IMAGE_LOADING_REGION) ? image.getHeight() : region.height();
        if (this.threeObject == null) {
            this.meshPromise.subscribe(model -> threeBridge.applyTexture((ThreeBridge.ThreeObject)model, image, x, y, w, h));
        } else {
            threeBridge.applyTexture(this.threeObject, image, x, y, w, h);
        }
    }

    @Override
    public void applyDynamicTexture(Sprite sprite) {
        this.dynamicTexture = sprite;
        this.applyTexture(this.dynamicTexture.getCurrentGraphics());
    }

    @Override
    public ThreeMeshWrapper copy() {
        return new ThreeMeshWrapper((Subject<ThreeBridge.ThreeObject>)this.meshPromise.map(original -> {
            ThreeBridge threeBridge = Browser.getThreeBridge();
            return threeBridge.cloneObject((ThreeBridge.ThreeObject)original);
        }));
    }

    @Generated
    public Subject<ThreeBridge.ThreeObject> getMeshPromise() {
        return this.meshPromise;
    }

    @Generated
    public ThreeBridge.ThreeObject getThreeObject() {
        return this.threeObject;
    }

    @Override
    @Generated
    public Transform3D getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public Transform3D getGlobalTransform() {
        return this.globalTransform;
    }

    @Override
    @Generated
    public Sprite getDynamicTexture() {
        return this.dynamicTexture;
    }
}

