/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Stage;

public interface SceneContext {
    public RenderConfig getConfig();

    default public Canvas getCanvas() {
        return this.getConfig().getCanvas();
    }

    public MediaLoader getMediaLoader();

    public InputDevice getInput();

    public Network getNetwork();

    public SceneManager getSceneManager();

    public Stage getStage();

    default public FrameStats getFrameStats() {
        return this.getSceneManager().getFrameStats();
    }

    default public void changeScene(Scene requestedScene) {
        this.getSceneManager().changeScene(requestedScene);
    }

    default public void attach(Scene subScene) {
        this.getSceneManager().attach(this, subScene);
    }

    default public void attach(Updatable subScene) {
        Scene wrappedSubScene = (context, deltaTime) -> subScene.update(deltaTime);
        this.attach(wrappedSubScene);
    }

    default public void attach(Runnable subScene) {
        Scene wrappedSubScene = (context, deltaTime) -> subScene.run();
        this.attach(wrappedSubScene);
    }

    default public void attachGlobal(Scene globalSubScene) {
        this.getSceneManager().attachGlobal(this, globalSubScene);
    }

    public Mesh createMesh(Shape3D var1, ColorRGB var2);

    default public Mesh createMesh(Shape3D shape) {
        return this.createMesh(shape, ColorRGB.WHITE);
    }

    public Point2D project(Point3D var1);

    public boolean castPickRay(Point2D var1, Box var2);

    public void takeScreenshot(File var1);

    public void terminate();

    public String getRendererName();

    default public List<String> getDebugInformation() {
        FrameStats frameStats = this.getSceneManager().getFrameStats();
        int targetFPS = this.getConfig().getFramerate();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Renderer:  " + this.getRendererName());
        info.add("Canvas:  " + String.valueOf(this.getCanvas()));
        info.add("Framerate:  " + Math.round(frameStats.getAverageFramerate()) + " / " + targetFPS);
        info.add("Update time:  " + frameStats.getFrameUpdateTime() + "ms");
        info.add("Render time:  " + frameStats.getFrameRenderTime() + "ms");
        if (!frameStats.getCustomStats().isEmpty()) {
            info.add("");
        }
        for (String customStat : frameStats.getCustomStats()) {
            info.add(customStat + ":  " + frameStats.getAverageTimeMS(customStat) + "ms");
        }
        return info;
    }
}

