/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import lombok.Generated;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.util.Stopwatch;

public class SceneManager {
    private Stopwatch timer;
    private long elapsedTime;
    private FrameStats frameStats;
    private SceneTree activeScene;
    private Queue<SceneTree> requestedSceneQueue;
    private List<Scene> globalSubScenes;
    private static final long FRAME_LEEWAY_MS = 5L;
    private static final float MIN_FRAME_TIME = 0.01f;
    private static final float MAX_FRAME_TIME = 0.2f;

    public SceneManager(Stopwatch timer) {
        this.timer = timer;
        this.elapsedTime = 0L;
        this.frameStats = new FrameStats();
        this.requestedSceneQueue = new LinkedList<SceneTree>();
        this.globalSubScenes = new ArrayList<Scene>();
    }

    public SceneManager() {
        this(new Stopwatch());
    }

    public int requestFrameUpdate(SceneContext context) {
        long frameTime = this.timer.tick();
        this.elapsedTime += frameTime;
        long targetFrameTime = Math.round(1000.0f / (float)context.getConfig().getFramerate());
        if (this.elapsedTime < targetFrameTime - 5L) {
            return 0;
        }
        this.frameStats.markEnd("$$frameTime");
        float deltaTime = Math.clamp((float)this.elapsedTime / 1000.0f, 0.01f, 0.2f);
        this.frameStats.markStart("$$frameUpdate");
        this.performFrameUpdate(context, deltaTime);
        this.frameStats.markEnd("$$frameUpdate");
        this.elapsedTime = 0L;
        return 1;
    }

    protected void performFrameUpdate(SceneContext context, float deltaTime) {
        this.updateInput(context.getInput(), deltaTime);
        if (!this.requestedSceneQueue.isEmpty()) {
            this.activateRequestedScene(context);
        }
        this.updateCurrentScene(context, this.activeScene, deltaTime);
        this.updateGlobalSubScenes(context, deltaTime);
    }

    private void updateInput(InputDevice input, float deltaTime) {
        if (!(input instanceof Renderer)) {
            input.update(deltaTime);
        }
        for (Pointer pointer : input.getPointers()) {
            pointer.update(deltaTime);
        }
    }

    private void updateCurrentScene(SceneContext context, SceneTree current, float deltaTime) {
        current.scene.update(context, deltaTime);
        for (Scene subScene : current.subScenes) {
            if (this.checkCompleted(context, current, subScene)) continue;
            subScene.update(context, deltaTime);
            this.checkCompleted(context, current, subScene);
        }
        context.getStage().getAnimationTimer().update(deltaTime);
    }

    private boolean checkCompleted(SceneContext context, SceneTree parent, Scene subScene) {
        if (subScene.isCompleted()) {
            subScene.end(context);
            parent.subScenes.remove(subScene);
            return true;
        }
        return false;
    }

    private void activateRequestedScene(SceneContext context) {
        SceneTree requestedScene;
        if (this.activeScene != null) {
            this.activeScene.walk(scene -> scene.end(context));
            context.getStage().clear();
            context.getStage().getAnimationTimer().reset();
        }
        if ((requestedScene = this.requestedSceneQueue.peek()) != null) {
            this.activeScene = requestedScene;
            this.activeScene.walk(scene -> scene.start(context));
            this.requestedSceneQueue.poll();
            if (!this.requestedSceneQueue.isEmpty()) {
                this.activateRequestedScene(context);
            }
        }
    }

    private void updateGlobalSubScenes(SceneContext context, float deltaTime) {
        Iterator<Scene> iterator = this.globalSubScenes.iterator();
        while (iterator.hasNext()) {
            Scene globalScene = iterator.next();
            globalScene.update(context, deltaTime);
            if (!globalScene.isCompleted()) continue;
            iterator.remove();
        }
    }

    public void changeScene(Scene requestedScene) {
        this.requestedSceneQueue.offer(new SceneTree(requestedScene));
    }

    public void attach(SceneContext context, Scene subScene) {
        if (this.requestedSceneQueue.isEmpty()) {
            this.activeScene.attachSubScene(subScene);
            subScene.start(context);
        } else {
            SceneTree requestedScene = this.requestedSceneQueue.peek();
            requestedScene.attachSubScene(subScene);
        }
    }

    public void attachGlobal(SceneContext context, Scene globalSubScene) {
        this.globalSubScenes.add(globalSubScene);
        globalSubScene.start(context);
    }

    public boolean isActiveScene(Scene scene) {
        if (this.activeScene == null) {
            return false;
        }
        if (this.activeScene.scene.equals(scene)) {
            return true;
        }
        return this.activeScene.subScenes.stream().anyMatch(subScene -> subScene.equals(scene));
    }

    @Generated
    public FrameStats getFrameStats() {
        return this.frameStats;
    }

    private static class SceneTree {
        private Scene scene;
        private List<Scene> subScenes;

        public SceneTree(Scene scene) {
            this.scene = scene;
            this.subScenes = new CopyOnWriteArrayList<Scene>();
        }

        public void attachSubScene(Scene subScene) {
            this.subScenes.add(subScene);
        }

        public void walk(Consumer<Scene> callback) {
            callback.accept(this.scene);
            this.subScenes.forEach(callback);
        }
    }
}

