/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.scene.MediaAssetStore;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.LoadStatus;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.util.Platform;
import nl.colorize.util.stats.Aggregate;

public class SplashScreen
implements Scene {
    private final MediaAssetStore mediaAssets;
    private final Supplier<Scene> nextScene;
    private final List<LoadStatus> loading;
    private Timer delay;
    private int barWidth;
    private int barHeight;
    private ColorRGB screenBackgroundColor;
    private ColorRGB barBorderColor;
    private int barBorderStroke;
    private ColorRGB barBackgroundColor;
    private int barBackgroundAlpha;
    private ColorRGB barForegroundColor;

    public SplashScreen(MediaAssetStore mediaAssets, Supplier<Scene> nextScene) {
        this.mediaAssets = mediaAssets;
        this.nextScene = nextScene;
        this.loading = new ArrayList<LoadStatus>();
        this.delay = new Timer(Platform.isDesktopPlatform() ? 0.0f : 0.4f);
        this.barWidth = 300;
        this.barHeight = 10;
        this.screenBackgroundColor = ColorRGB.parseHex("#EBEBEB");
        this.barBorderColor = null;
        this.barBorderStroke = 1;
        this.barBackgroundColor = ColorRGB.parseHex("#adadad");
        this.barBackgroundAlpha = 100;
        this.barForegroundColor = ColorRGB.parseHex("#e45d61");
    }

    @Override
    public void start(SceneContext context) {
        this.attachProgressBar(context);
        this.loadMediaAssets(context.getMediaLoader(), context.getNetwork());
    }

    private void loadMediaAssets(MediaLoader mediaLoader, Network network) {
        if (!this.mediaAssets.isLoaded()) {
            this.mediaAssets.loadMedia(mediaLoader, network);
        }
        this.loading.addAll(mediaLoader.getLoadStatus().flush().toList());
    }

    protected void attachProgressBar(SceneContext context) {
        int canvasWidth = context.getStage().getCanvas().getWidth();
        int canvasHeight = context.getStage().getCanvas().getHeight();
        Container progressBar = new Container();
        progressBar.getTransform().setPosition(context.getStage().getCanvas().getCenter());
        context.getStage().getRoot().addChild(progressBar);
        if (this.screenBackgroundColor != null) {
            Rect screen = Rect.aroundOrigin(canvasWidth, canvasHeight);
            progressBar.addChild(new Primitive(screen, this.screenBackgroundColor));
        }
        if (this.barBorderStroke >= 1 && this.barBorderColor != null) {
            Rect border = Rect.aroundOrigin(canvasWidth + this.barBorderStroke * 2, canvasHeight + this.barBorderStroke * 2);
            progressBar.addChild(new Primitive(border, this.barBorderColor));
        }
        Rect barBackground = Rect.aroundOrigin(this.barWidth, this.barHeight);
        progressBar.addChild(new Primitive(barBackground, this.barBackgroundColor, this.barBackgroundAlpha));
        Primitive foreground = new Primitive(Rect.aroundOrigin(1.0f, this.barHeight), this.barForegroundColor);
        progressBar.addChild(foreground);
        context.attach(deltaTime -> this.animateProgressBar(foreground));
    }

    private void animateProgressBar(Primitive foreground) {
        int completed = (int)this.loading.stream().filter(LoadStatus::isLoaded).count();
        float loadDelta = Aggregate.fraction((float)completed, (float)this.loading.size());
        float delayDelta = this.delay.isCompleted() ? 1.0f : this.delay.getRatio();
        float delta = 0.5f * loadDelta + 0.5f * delayDelta;
        foreground.setShape(new Rect((float)(-this.barWidth) / 2.0f, (float)(-this.barHeight) / 2.0f, delta * (float)this.barWidth, this.barHeight));
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        this.delay.update(deltaTime);
        if (this.isLoadingCompleted()) {
            context.changeScene(this.nextScene.get());
        }
    }

    private boolean isLoadingCompleted() {
        return this.delay.isCompleted() && this.loading.stream().allMatch(LoadStatus::isLoaded);
    }

    @Generated
    public MediaAssetStore getMediaAssets() {
        return this.mediaAssets;
    }

    @Generated
    public Supplier<Scene> getNextScene() {
        return this.nextScene;
    }

    @Generated
    public List<LoadStatus> getLoading() {
        return this.loading;
    }

    @Generated
    public Timer getDelay() {
        return this.delay;
    }

    @Generated
    public int getBarWidth() {
        return this.barWidth;
    }

    @Generated
    public int getBarHeight() {
        return this.barHeight;
    }

    @Generated
    public ColorRGB getScreenBackgroundColor() {
        return this.screenBackgroundColor;
    }

    @Generated
    public ColorRGB getBarBorderColor() {
        return this.barBorderColor;
    }

    @Generated
    public int getBarBorderStroke() {
        return this.barBorderStroke;
    }

    @Generated
    public ColorRGB getBarBackgroundColor() {
        return this.barBackgroundColor;
    }

    @Generated
    public int getBarBackgroundAlpha() {
        return this.barBackgroundAlpha;
    }

    @Generated
    public ColorRGB getBarForegroundColor() {
        return this.barForegroundColor;
    }

    @Generated
    public void setDelay(Timer delay) {
        this.delay = delay;
    }

    @Generated
    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    @Generated
    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
    }

    @Generated
    public void setScreenBackgroundColor(ColorRGB screenBackgroundColor) {
        this.screenBackgroundColor = screenBackgroundColor;
    }

    @Generated
    public void setBarBorderColor(ColorRGB barBorderColor) {
        this.barBorderColor = barBorderColor;
    }

    @Generated
    public void setBarBorderStroke(int barBorderStroke) {
        this.barBorderStroke = barBorderStroke;
    }

    @Generated
    public void setBarBackgroundColor(ColorRGB barBackgroundColor) {
        this.barBackgroundColor = barBackgroundColor;
    }

    @Generated
    public void setBarBackgroundAlpha(int barBackgroundAlpha) {
        this.barBackgroundAlpha = barBackgroundAlpha;
    }

    @Generated
    public void setBarForegroundColor(ColorRGB barForegroundColor) {
        this.barForegroundColor = barForegroundColor;
    }
}

