/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import lombok.Generated;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.Subject;
import nl.colorize.util.TextUtils;

public class LoadStatus {
    private final ResourceFile file;
    private boolean loaded;
    private float time;

    private LoadStatus(ResourceFile file) {
        this.file = file;
        this.loaded = false;
        this.time = 0.0f;
    }

    public String toString() {
        if (this.loaded) {
            return String.valueOf(this.file) + "[" + TextUtils.numberFormat((float)this.time, (int)1) + "s]";
        }
        return String.valueOf(this.file) + "[loading]";
    }

    public static LoadStatus track(ResourceFile file, Subject<?> operation) {
        LoadStatus loadStatus = new LoadStatus(file);
        Stopwatch timer = new Stopwatch();
        operation.subscribe(event -> {
            loadStatus.setLoaded(true);
            loadStatus.setTime((float)timer.tock() / 1000.0f);
        });
        return loadStatus;
    }

    @Generated
    public ResourceFile getFile() {
        return this.file;
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public float getTime() {
        return this.time;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Generated
    public void setTime(float time) {
        this.time = time;
    }
}

