/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import lombok.Generated;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.multimedialib.stage.Transform;

public class Primitive
implements StageNode2D {
    private Transform transform = new Transform();
    private Transform globalTransform = new Transform();
    private Shape shape;
    private ColorRGB color;
    private float stroke;

    public Primitive(Shape shape, ColorRGB color) {
        this.shape = shape;
        this.color = color;
        this.stroke = 1.0f;
    }

    public Primitive(Shape shape, ColorRGB color, float alpha) {
        this(shape, color);
        this.getTransform().setAlpha(alpha);
    }

    @Override
    public Rect getStageBounds() {
        return this.shape.reposition(this.globalTransform.getPosition()).getBoundingBox();
    }

    @Override
    public void animate(Timer sceneTime) {
    }

    public String toString() {
        if (this.shape instanceof Rect || this.shape instanceof Circle) {
            return this.shape.getClass().getSimpleName() + " [" + String.valueOf(this.shape) + "]";
        }
        return this.shape.getClass().getSimpleName();
    }

    @Override
    @Generated
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    @Generated
    public Transform getGlobalTransform() {
        return this.globalTransform;
    }

    @Generated
    public Shape getShape() {
        return this.shape;
    }

    @Generated
    public ColorRGB getColor() {
        return this.color;
    }

    @Generated
    public float getStroke() {
        return this.stroke;
    }

    @Generated
    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    @Generated
    public void setGlobalTransform(Transform globalTransform) {
        this.globalTransform = globalTransform;
    }

    @Generated
    public void setShape(Shape shape) {
        this.shape = shape;
    }

    @Generated
    public void setColor(ColorRGB color) {
        this.color = color;
    }

    @Generated
    public void setStroke(float stroke) {
        this.stroke = stroke;
    }
}

