/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.util.TextUtils;
import nl.colorize.util.stats.Cache;

public class SpriteAtlas {
    private Map<String, SubImage> subImages = new HashMap<String, SubImage>();
    private Cache<String, Image> subImageCache = Cache.from(this::loadSubImage);

    private String normalizeSubImageName(String name) {
        name = TextUtils.removeTrailing((String)name, (String)".png");
        name = TextUtils.removeTrailing((String)name, (String)".jpg");
        name = TextUtils.removeTrailing((String)name, (String)".jpeg");
        return name;
    }

    public void add(String name, Image atlas, Region region) {
        Preconditions.checkArgument((!(name = this.normalizeSubImageName(name)).isEmpty() ? 1 : 0) != 0, (Object)("Invalid sub-image name: " + name));
        Preconditions.checkArgument((!this.subImages.containsKey(name) ? 1 : 0) != 0, (Object)("Duplicate sub-image: " + name));
        SubImage subImage = new SubImage(name, atlas, region);
        this.subImages.put(name, subImage);
    }

    private void add(SubImage subImage) {
        this.add(subImage.name, subImage.atlas, subImage.region);
    }

    public Image get(String name) {
        name = this.normalizeSubImageName(name);
        return (Image)this.subImageCache.get((Object)name);
    }

    private Image loadSubImage(String name) {
        SubImage subImage = this.subImages.get(name);
        if (subImage == null) {
            throw new NoSuchElementException("No such sub-image: " + name);
        }
        return subImage.atlas.extractRegion(subImage.region);
    }

    public List<Image> get(List<String> names) {
        return names.stream().map(this::get).toList();
    }

    public List<Image> get(Predicate<String> filter) {
        return this.subImages.keySet().stream().filter(filter).sorted().map(this::get).toList();
    }

    public List<Image> getAll() {
        return this.get((String name) -> true);
    }

    public boolean contains(String name) {
        return this.subImages.containsKey(name);
    }

    public SpriteAtlas merge(SpriteAtlas other) {
        SpriteAtlas merged = new SpriteAtlas();
        this.subImages.values().forEach(merged::add);
        other.subImages.values().forEach(merged::add);
        return merged;
    }

    public static SpriteAtlas merge(List<SpriteAtlas> atlases) {
        Preconditions.checkArgument((!atlases.isEmpty() ? 1 : 0) != 0, (Object)"No sprite atlas provided");
        SpriteAtlas result = atlases.getFirst();
        for (int i = 1; i < atlases.size(); ++i) {
            result = result.merge(atlases.get(i));
        }
        return result;
    }

    private record SubImage(String name, Image atlas, Region region) {
    }
}

