/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.tool.Demo2D;
import nl.colorize.multimedialib.tool.Demo3D;
import nl.colorize.multimedialib.tool.DemoIsometric;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;

public class DemoLauncher {
    @Arg(name="--renderer", usage="One of 'java2d', 'javafx', 'gdx'.")
    protected String rendererName;
    @Arg(usage="One of '2d', '3d', 'isometric'.")
    protected String graphics;
    @Arg(defaultValue="60", usage="Framerate, default is 60 fps.")
    protected int framerate;
    @Arg(usage="Starts the demo fullscreen instead of in a window.")
    protected boolean fullscreen;
    @Arg(name="--zoom", usage="Uses a fixed canvas size to display graphics.")
    protected boolean canvasZoom;

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser(DemoLauncher.class);
        DemoLauncher launcher = (DemoLauncher)argParser.parse(argv, DemoLauncher.class);
        launcher.start();
    }

    private void start() {
        GraphicsMode graphicsMode = this.graphics.equals("3d") ? GraphicsMode.MODE_3D : GraphicsMode.MODE_2D;
        ScaleStrategy scaleStrategy = this.canvasZoom ? ScaleStrategy.scale() : ScaleStrategy.flexible();
        Canvas canvas = new Canvas(800, 600, scaleStrategy);
        RenderConfig config = RenderConfig.forDesktop(this.rendererName, graphicsMode, canvas);
        config.setFramerate(this.framerate);
        config.getWindowOptions().setTitle("MultimediaLib - Demo");
        config.getWindowOptions().setFullscreen(this.fullscreen);
        switch (this.graphics) {
            case "2d": {
                config.start(new Demo2D());
                break;
            }
            case "3d": {
                config.start(new Demo3D());
                break;
            }
            case "isometric": {
                config.start(new DemoIsometric());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

