/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.stream.Stream;

public class Grid<E> {
    private int gridX0;
    private int gridY0;
    private int gridX1;
    private int gridY1;
    private E[][] cells;

    public Grid() {
        this(0, 0, 0, 0);
    }

    private Grid(int x0, int y0, int x1, int y1) {
        this.validateCoordinates(x0, y0, x1, y1);
        this.gridX0 = x0;
        this.gridY0 = y0;
        this.gridX1 = x1;
        this.gridY1 = y1;
        this.cells = new Object[x1 - x0][y1 - y0];
    }

    private void validateCoordinates(int x0, int y0, int x1, int y1) {
        Preconditions.checkArgument((x0 <= x1 && y0 <= y1 ? 1 : 0) != 0, (Object)("Invalid grid coordinates: " + x0 + ", " + y0 + ", " + x1 + ", " + y1));
    }

    private boolean contains(int x, int y) {
        return x >= this.gridX0 && x < this.gridX1 && y >= this.gridY0 && y < this.gridY1;
    }

    private void resize(int x0, int y0, int x1, int y1) {
        this.validateCoordinates(x0, y0, x1, y1);
        Grid<E> helper = new Grid<E>(x0, y0, x1, y1);
        for (int x = this.gridX0; x < this.gridX1; ++x) {
            for (int y = this.gridY0; y < this.gridY1; ++y) {
                helper.set(x, y, this.get(x, y));
            }
        }
        this.gridX0 = helper.gridX0;
        this.gridY0 = helper.gridY0;
        this.gridX1 = helper.gridX1;
        this.gridY1 = helper.gridY1;
        this.cells = helper.cells;
    }

    public void set(int x, int y, E value) {
        if (!this.contains(x, y)) {
            this.resize(Math.min(x, this.gridX0), Math.min(y, this.gridY0), Math.max(x + 1, this.gridX1), Math.max(y + 1, this.gridY1));
        }
        this.cells[x - this.gridX0][y - this.gridY0] = value;
    }

    public E get(int x, int y) {
        if (!this.contains(x, y)) {
            return null;
        }
        return this.cells[x - this.gridX0][y - this.gridY0];
    }

    public Stream<E> stream() {
        return Arrays.stream(this.cells).flatMap(Arrays::stream).filter(value -> value != null);
    }

    public Stream<E> stream(int x0, int y0, int x1, int y1) {
        this.validateCoordinates(x0, y0, x1, y1);
        Stream.Builder<E> stream = Stream.builder();
        for (int y = y0; y < y1; ++y) {
            for (int x = x0; x < x1; ++x) {
                if (this.cells[x - this.gridX0][y - this.gridY0] == null) continue;
                stream.add(this.cells[x - this.gridX0][y - this.gridY0]);
            }
        }
        return stream.build();
    }
}

