/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import nl.colorize.multimedialib.math.Angle;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.math.Vector;

public record Polygon(List<Point2D> points) implements Shape
{
    public Polygon(List<Point2D> points) {
        Preconditions.checkArgument((points.size() >= 3 ? 1 : 0) != 0, (Object)("Convex polygon must have at least 3 points, got " + points.size()));
        this.points = List.copyOf(points);
    }

    public float[] toPoints() {
        float[] result = new float[this.points.size() * 2];
        for (int i = 0; i < this.points.size(); ++i) {
            result[i * 2] = this.points.get(i).x();
            result[i * 2 + 1] = this.points.get(i).y();
        }
        return result;
    }

    @Deprecated
    public int getNumPoints() {
        return this.points.size();
    }

    @Deprecated
    public float getPointX(int n) {
        return this.points.get(n).x();
    }

    @Deprecated
    public float getPointY(int n) {
        return this.points.get(n).y();
    }

    @Deprecated
    public Point2D getPoint(int n) {
        return this.points.get(n);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.isPointInPolygon(p.x(), p.y()) || this.isPointOnLineSegment(p.x(), p.y());
    }

    private boolean isPointInPolygon(float px, float py) {
        boolean oddNodes = false;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = this.points.getLast().x();
        float y2 = this.points.getLast().y();
        for (int i = 0; i < this.points.size(); ++i) {
            x1 = this.points.get(i).x();
            y1 = this.points.get(i).y();
            if ((y1 < py && y2 >= py || y1 >= py && y2 < py) && (py - y1) / (y2 - y1) * (x2 - x1) < px - x1) {
                oddNodes = !oddNodes;
            }
            x2 = x1;
            y2 = y1;
        }
        return oddNodes;
    }

    private boolean isPointOnLineSegment(float px, float py) {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D current = this.points.get(i);
            Point2D next = this.points.get(i + 1);
            if (!this.isPointOnLineSegment(current.x(), current.y(), next.x(), next.y(), px, py)) continue;
            return true;
        }
        return this.isPointOnLineSegment(this.points.getLast().x(), this.points.getLast().y(), this.points.getFirst().x(), this.points.getFirst().y(), px, py);
    }

    private boolean isPointOnLineSegment(float x0, float y0, float x1, float y1, float px, float py) {
        float crossproduct = (py - y0) * (x1 - x0) - (px - x0) * (y1 - y0);
        if (crossproduct != 0.0f) {
            return false;
        }
        float dotproduct = (px - x0) * (x1 - x0) + (py - y0) * (x1 - y0);
        if (dotproduct < 0.0f) {
            return false;
        }
        float squaredLength = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
        return dotproduct <= squaredLength;
    }

    public boolean intersects(Polygon p) {
        float[] points = this.toPoints();
        float[] pPoints = p.toPoints();
        for (int i = 0; i < points.length; i += 2) {
            int iNext = i + 2;
            if (iNext >= points.length) {
                iNext = 0;
            }
            for (int j = 0; j < pPoints.length; j += 2) {
                int jNext = j + 2;
                if (jNext >= pPoints.length) {
                    jNext = 0;
                }
                double unknownA = ((points[iNext] - points[i]) * (pPoints[j + 1] - points[i + 1]) - (points[iNext + 1] - points[i + 1]) * (pPoints[j] - points[i])) / ((points[iNext + 1] - points[i + 1]) * (pPoints[jNext] - pPoints[j]) - (points[iNext] - points[i]) * (pPoints[jNext + 1] - pPoints[j + 1]));
                double unknownB = ((pPoints[jNext] - pPoints[j]) * (pPoints[j + 1] - points[i + 1]) - (pPoints[jNext + 1] - pPoints[j + 1]) * (pPoints[j] - points[i])) / ((points[iNext + 1] - points[i + 1]) * (pPoints[jNext] - pPoints[j]) - (points[iNext] - points[i]) * (pPoints[jNext + 1] - pPoints[j + 1]));
                if (!(unknownA >= 0.0) || !(unknownA <= 1.0) || !(unknownB >= 0.0) || !(unknownB <= 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Rect getBoundingBox() {
        float minX = this.points.getFirst().x();
        float minY = this.points.getFirst().y();
        float maxX = minX;
        float maxY = minY;
        for (int i = 1; i < this.points.size(); ++i) {
            minX = Math.min(minX, this.points.get(i).x());
            minY = Math.min(minY, this.points.get(i).y());
            maxX = Math.max(maxX, this.points.get(i).x());
            maxY = Math.max(maxY, this.points.get(i).y());
        }
        return new Rect(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public Point2D getCenter() {
        return this.getBoundingBox().getCenter();
    }

    public List<Polygon> subdivide() {
        if (this.points.size() == 3) {
            return List.of(this);
        }
        List<Point2D> vertices = this.subdivideVertices();
        ArrayList<Polygon> triangles = new ArrayList<Polygon>();
        for (int i = 0; i < vertices.size(); i += 3) {
            triangles.add(new Polygon(List.of(vertices.get(i), vertices.get(i + 1), vertices.get(i + 2))));
        }
        return triangles;
    }

    private List<Point2D> subdivideVertices() {
        float[] points = this.toPoints();
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        Point2D center = this.getCenter();
        for (int i = 0; i < points.length; i += 2) {
            vertices.add(new Point2D(points[i], points[i + 1]));
            if (i >= 2) {
                vertices.add(center);
                vertices.add(new Point2D(points[i], points[i + 1]));
            }
            if (i != points.length - 2) continue;
            vertices.add(new Point2D(points[0], points[1]));
            vertices.add(center);
        }
        return vertices;
    }

    public Polygon map(Function<Point2D, Point2D> mapper) {
        List<Point2D> newPoints = this.points.stream().map(mapper).toList();
        return new Polygon(newPoints);
    }

    @Override
    public Polygon reposition(Point2D offset) {
        return this.map(p -> p.add(offset));
    }

    @Override
    public String toString() {
        return "Polygon";
    }

    public static Polygon fromPoints(float ... points) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (int i = 0; i < points.length; i += 2) {
            result.add(new Point2D(points[i], points[i + 1]));
        }
        return new Polygon(result);
    }

    public static Polygon createCircle(Point2D origin, float radius, int numPoints) {
        Preconditions.checkArgument((numPoints >= 4 ? 1 : 0) != 0, (Object)("Too few points: " + numPoints));
        Preconditions.checkArgument((radius > 0.001f ? 1 : 0) != 0, (Object)("Invalid radius: " + radius));
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int i = 0; i < numPoints; ++i) {
            Vector vector = new Vector((float)i * (360.0f / (float)numPoints), radius);
            points.add(new Point2D(origin.x() + vector.getX(), origin.y() + vector.getY()));
        }
        return new Polygon(points);
    }

    public static Polygon createCircle(float radius, int numPoints) {
        return Polygon.createCircle(Point2D.ORIGIN, radius, numPoints);
    }

    public static Polygon createCone(Point2D origin, Angle angle, float arc, float length) {
        return Polygon.createCone(origin, angle.degrees(), arc, length);
    }

    public static Polygon createCone(Point2D origin, float angle, float arc, float length) {
        Preconditions.checkArgument((arc > 0.0f && arc <= 180.0f ? 1 : 0) != 0, (Object)("Invalid arc: " + arc));
        Preconditions.checkArgument((length > 0.0f ? 1 : 0) != 0, (Object)("Invalid length: " + length));
        Vector left = new Vector(angle % 360.0f - arc / 2.0f, length);
        Vector center = new Vector(angle % 360.0f, length);
        Vector right = new Vector(angle % 360.0f + arc / 2.0f, length);
        return new Polygon(List.of(origin, new Point2D(origin.x() + left.getX(), origin.y() + left.getY()), new Point2D(origin.x() + center.getX(), origin.y() + center.getY()), new Point2D(origin.x() + right.getX(), origin.y() + right.getY())));
    }
}

