/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;

public record Region(int x, int y, int width, int height) {
    public Region {
        Preconditions.checkArgument((x >= 0 ? 1 : 0) != 0, (Object)("Invalid X: " + x));
        Preconditions.checkArgument((y >= 0 ? 1 : 0) != 0, (Object)("Invalid Y: " + y));
        Preconditions.checkArgument((width >= 1 ? 1 : 0) != 0, (Object)("Invalid width: " + width));
        Preconditions.checkArgument((height >= 1 ? 1 : 0) != 0, (Object)("Invalid height: " + height));
    }

    public int x1() {
        return this.x + this.width;
    }

    public int y1() {
        return this.y + this.height;
    }

    public Region move(int deltaX, int deltaY) {
        return new Region(this.x + deltaX, this.y + deltaY, this.width, this.height);
    }

    @Override
    public String toString() {
        return this.x + ", " + this.y + ", " + this.width + ", " + this.height;
    }
}

