/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;

public record Sphere(Point3D center, float radius) implements Shape3D
{
    public Sphere {
        Preconditions.checkArgument((radius >= 0.0f ? 1 : 0) != 0, (Object)("Invalid radius: " + radius));
    }

    public Sphere(float radius) {
        this(Point3D.ORIGIN, radius);
    }

    @Override
    public Box getBoundingBox() {
        return Box.around(this.center, this.radius * 2.0f, this.radius * 2.0f, this.radius * 2.0f);
    }

    @Override
    public Point3D getCenter() {
        return this.center;
    }

    @Override
    public boolean contains(Point3D point) {
        return this.center.distanceTo(point) <= this.radius;
    }

    @Override
    public Sphere reposition(Point3D offset) {
        return new Sphere(this.center.add(offset), this.radius);
    }
}

