/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.stats.Aggregate;

public class FrameStats {
    private Map<String, PhaseStats> stats = new LinkedHashMap<String, PhaseStats>();
    public static final String PHASE_FRAME_TIME = "$$frameTime";
    public static final String PHASE_FRAME_UPDATE = "$$frameUpdate";
    public static final String PHASE_FRAME_RENDER = "$$frameRender";
    public static final int BUFFER_CAPACITY = 60;

    private PhaseStats prepare(String phase) {
        PhaseStats phaseStats = this.stats.get(phase);
        if (phaseStats == null) {
            phaseStats = new PhaseStats(phase, new Stopwatch(), new LinkedList<Long>());
            this.stats.put(phase, phaseStats);
        }
        return phaseStats;
    }

    public void markStart(String phase) {
        PhaseStats phaseStats = this.prepare(phase);
        phaseStats.timer.tick();
    }

    public void markEnd(String phase) {
        PhaseStats phaseStats = this.prepare(phase);
        long value = phaseStats.timer.tick();
        phaseStats.values.add(value);
        while (phaseStats.values.size() > 60) {
            phaseStats.values.removeFirst();
        }
    }

    public float getAverageFramerate() {
        int frameTimeMS = this.getAverageTimeMS(PHASE_FRAME_TIME);
        return 1000.0f / (float)Math.max(frameTimeMS, 1);
    }

    public int getFrameUpdateTime() {
        return this.getAverageTimeMS(PHASE_FRAME_UPDATE);
    }

    public int getFrameRenderTime() {
        return this.getAverageTimeMS(PHASE_FRAME_RENDER);
    }

    public int getAverageTimeMS(String phase) {
        PhaseStats phaseStats = this.prepare(phase);
        return (int)Aggregate.average(phaseStats.values);
    }

    public float getAverageTime(String phase) {
        return (float)this.getAverageTimeMS(phase) / 1000.0f;
    }

    public List<String> getCustomStats() {
        return this.stats.keySet().stream().filter(phase -> !phase.startsWith("$$")).toList();
    }

    public Iterable<Long> getFrameTimes(String phase) {
        return this.prepare(phase).values();
    }

    public int getBufferSize() {
        return this.prepare(PHASE_FRAME_TIME).values().size();
    }

    private record PhaseStats(String phase, Stopwatch timer, Deque<Long> values) {
    }
}

