/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.collect.Streams;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.util.EventQueue;

public interface InputDevice
extends Updatable {
    public Iterable<Pointer> getPointers();

    default public boolean isPointerPressed(Rect bounds) {
        return Streams.stream(this.getPointers()).anyMatch(pointer -> pointer.isPressed(bounds));
    }

    default public boolean isPointerPressed(StageNode2D node) {
        return this.isPointerPressed(node.getStageBounds()) && node.getGlobalTransform().isVisible();
    }

    default public boolean isPointerReleased(Rect bounds) {
        return Streams.stream(this.getPointers()).anyMatch(pointer -> pointer.isReleased(bounds));
    }

    default public boolean isPointerReleased(StageNode2D node) {
        return this.isPointerReleased(node.getStageBounds()) && node.getGlobalTransform().isVisible();
    }

    @Deprecated
    public void clearPointerState();

    public boolean isTouchAvailable();

    public boolean isKeyboardAvailable();

    public boolean isKeyPressed(KeyCode var1);

    public boolean isKeyReleased(KeyCode var1);

    public EventQueue<String> requestTextInput(String var1, String var2);

    public void fillClipboard(String var1);
}

