/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nl.colorize.util.stats.Tuple;
import nl.colorize.util.stats.TupleList;

public class Response {
    private int status;
    private TupleList<String, String> headers;
    private String body;

    public Response(int status, TupleList<String, String> headers, String body) {
        this.status = status;
        this.headers = headers.immutable();
        this.body = body;
    }

    public Optional<String> getHeader(String name) {
        return this.headers.stream().filter(header -> ((String)header.left()).equalsIgnoreCase(name)).map(Tuple::right).findFirst();
    }

    public List<String> getHeaderValues(String name) {
        return this.headers.stream().filter(header -> ((String)header.left()).equalsIgnoreCase(name)).map(Tuple::right).toList();
    }

    public Optional<String> getContentType() {
        return this.getHeader("Content-Type");
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public TupleList<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getBody() {
        return this.body;
    }
}

