/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import java.io.File;
import java.util.List;
import lombok.Generated;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.util.Development;
import nl.colorize.util.EventQueue;

@Development
public class HeadlessRenderer
implements Renderer,
SceneContext,
InputDevice {
    private boolean graphicsEnvironmentEnabled;
    private RenderConfig config;
    private StageVisitor graphics;
    private MediaLoader mediaLoader;
    private Network network;
    private SceneManager sceneManager;
    private Stage stage;
    private boolean touchAvailable;
    private boolean keyboardAvailable;
    private Point2D pointer;
    private boolean pointerPressed;
    private boolean pointerReleased;
    public static final FontFace DEFAULT_FONT = new FontFace(null, "sans-serif", 10, ColorRGB.BLACK);

    public HeadlessRenderer(boolean graphicsEnvironmentEnabled) {
        this.graphicsEnvironmentEnabled = graphicsEnvironmentEnabled;
        this.touchAvailable = false;
        this.keyboardAvailable = false;
        this.pointer = new Point2D(0.0f, 0.0f);
        this.pointerPressed = false;
        this.pointerReleased = false;
        Canvas defaultCanvas = new Canvas(800, 600, ScaleStrategy.flexible());
        RenderConfig defaultConfig = RenderConfig.headless(GraphicsMode.HEADLESS, defaultCanvas);
        defaultConfig.setFramerate(10);
        Scene nullScene = (context, deltaTime) -> {};
        this.start(defaultConfig, nullScene);
    }

    @Override
    public void start(RenderConfig config, Scene initialScene) {
        this.config = config;
        this.graphics = null;
        this.mediaLoader = new StandardMediaLoader();
        this.network = new StandardNetwork();
        this.sceneManager = new SimulatedSceneManager(this);
        this.stage = new Stage(config.getGraphicsMode(), config.getCanvas());
        this.sceneManager.changeScene(initialScene);
        this.doFrame(0.0f);
    }

    public void start(Scene initialScene) {
        this.start(this.config, initialScene);
    }

    @Override
    public void terminate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2D project(Point3D position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void takeScreenshot(File screenshotFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRendererName() {
        return "Headless renderer";
    }

    @Override
    public boolean isSupported(GraphicsMode graphicsMode) {
        return true;
    }

    @Deprecated
    public SceneContext getContext() {
        return this;
    }

    public void doFrame() {
        this.update(1.0f);
    }

    public void doFrame(float deltaTime) {
        this.update(deltaTime);
    }

    @Override
    public void update(float deltaTime) {
        SceneManager sceneManager = this.sceneManager;
        if (sceneManager instanceof SimulatedSceneManager) {
            SimulatedSceneManager simulated = (SimulatedSceneManager)sceneManager;
            simulated.simulateFrameUpdate(deltaTime);
        }
    }

    @Override
    public InputDevice getInput() {
        return this;
    }

    @Override
    public Iterable<Pointer> getPointers() {
        Pointer pointerObject = new Pointer("headless");
        pointerObject.setPosition(this.pointer);
        if (this.pointerReleased) {
            pointerObject.setState(2);
        } else if (this.pointerPressed) {
            pointerObject.setState(1);
        } else {
            pointerObject.setState(0);
        }
        return List.of(pointerObject);
    }

    @Override
    public void clearPointerState() {
        this.pointerPressed = false;
        this.pointerReleased = false;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return false;
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return false;
    }

    @Override
    public EventQueue<String> requestTextInput(String label, String initialValue) {
        return new EventQueue();
    }

    @Override
    public void fillClipboard(String text) {
    }

    @Generated
    public boolean isGraphicsEnvironmentEnabled() {
        return this.graphicsEnvironmentEnabled;
    }

    @Override
    @Generated
    public RenderConfig getConfig() {
        return this.config;
    }

    @Generated
    public StageVisitor getGraphics() {
        return this.graphics;
    }

    @Override
    @Generated
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    @Generated
    public Network getNetwork() {
        return this.network;
    }

    @Override
    @Generated
    public SceneManager getSceneManager() {
        return this.sceneManager;
    }

    @Override
    @Generated
    public Stage getStage() {
        return this.stage;
    }

    @Override
    @Generated
    public boolean isTouchAvailable() {
        return this.touchAvailable;
    }

    @Override
    @Generated
    public boolean isKeyboardAvailable() {
        return this.keyboardAvailable;
    }

    @Generated
    public Point2D getPointer() {
        return this.pointer;
    }

    @Generated
    public boolean isPointerPressed() {
        return this.pointerPressed;
    }

    @Generated
    public boolean isPointerReleased() {
        return this.pointerReleased;
    }

    @Generated
    public void setGraphicsEnvironmentEnabled(boolean graphicsEnvironmentEnabled) {
        this.graphicsEnvironmentEnabled = graphicsEnvironmentEnabled;
    }

    @Generated
    public void setConfig(RenderConfig config) {
        this.config = config;
    }

    @Generated
    public void setGraphics(StageVisitor graphics) {
        this.graphics = graphics;
    }

    @Generated
    public void setMediaLoader(MediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
    }

    @Generated
    public void setNetwork(Network network) {
        this.network = network;
    }

    @Generated
    public void setSceneManager(SceneManager sceneManager) {
        this.sceneManager = sceneManager;
    }

    @Generated
    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @Generated
    public void setTouchAvailable(boolean touchAvailable) {
        this.touchAvailable = touchAvailable;
    }

    @Generated
    public void setKeyboardAvailable(boolean keyboardAvailable) {
        this.keyboardAvailable = keyboardAvailable;
    }

    @Generated
    public void setPointer(Point2D pointer) {
        this.pointer = pointer;
    }

    @Generated
    public void setPointerPressed(boolean pointerPressed) {
        this.pointerPressed = pointerPressed;
    }

    @Generated
    public void setPointerReleased(boolean pointerReleased) {
        this.pointerReleased = pointerReleased;
    }

    private static class SimulatedSceneManager
    extends SceneManager {
        public SimulatedSceneManager(SceneContext context) {
            super(context);
        }

        public void simulateFrameUpdate(float deltaTime) {
            this.performFrameUpdate(deltaTime);
        }
    }
}

