/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.PeerConnection;
import nl.colorize.multimedialib.renderer.Response;
import nl.colorize.util.EventQueue;
import nl.colorize.util.Platform;
import nl.colorize.util.http.URLLoader;
import nl.colorize.util.stats.TupleList;
import org.jspecify.annotations.Nullable;

public class StandardNetwork
implements Network {
    @Override
    public EventQueue<Response> send(String method, String url, Map<String, String> headers, @Nullable String body) {
        LinkedHashMap<String, String> combinedHeaders = new LinkedHashMap<String, String>();
        combinedHeaders.put("X-Colorize-Platform", Platform.getPlatformName());
        combinedHeaders.put("X-Requested-With", "MultimediaLib");
        combinedHeaders.putAll(headers);
        HttpRequest request = URLLoader.buildRequest((String)method, (String)url, combinedHeaders, (String)body);
        EventQueue eventQueue = new EventQueue();
        URLLoader.sendAsync((HttpRequest)request).map(this::mapResponse).subscribe(arg_0 -> ((EventQueue)eventQueue).onNext(arg_0), arg_0 -> ((EventQueue)eventQueue).onError(arg_0));
        return eventQueue;
    }

    private Response mapResponse(HttpResponse<String> response) {
        TupleList headers = new TupleList();
        for (Map.Entry<String, List<String>> header : response.headers().map().entrySet()) {
            for (String value : header.getValue()) {
                headers.add((Object)header.getKey(), (Object)value);
            }
        }
        return new Response(response.statusCode(), (TupleList<String, String>)headers, response.body());
    }

    @Override
    public PeerConnection openPeerConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPeerToPeerSupported() {
        return false;
    }
}

