/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.jfx;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import nl.colorize.multimedialib.renderer.jfx.JFXGraphics;
import nl.colorize.multimedialib.renderer.jfx.JFXInput;
import nl.colorize.multimedialib.renderer.jfx.JFXRenderer;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.util.LogHelper;
import nl.colorize.util.swing.Utils2D;

public class JFXAnimationLoop
extends Application {
    private JFXRenderer renderer;
    private JFXGraphics graphics;
    private JFXInput input;
    private Stage stage;
    private static final Logger LOGGER = LogHelper.getLogger(JFXAnimationLoop.class);

    public void start(Stage stage) throws Exception {
        this.stage = stage;
        this.renderer = JFXRenderer.accessInstance();
        this.graphics = this.renderer.getGraphics();
        this.input = this.renderer.getInput();
        this.populateUI(stage);
        this.startAnimationLoop();
    }

    private void populateUI(Stage stage) {
        int width = this.renderer.getCanvas().getWidth();
        int height = this.renderer.getCanvas().getHeight();
        Canvas fxCanvas = new Canvas((double)width, (double)height);
        Group root = new Group();
        root.getChildren().add((Object)fxCanvas);
        Scene fxScene = new Scene((Parent)root);
        this.graphics.init(fxCanvas);
        this.attachEventHandlers(fxScene, fxCanvas);
        stage.setScene(fxScene);
        stage.setTitle(this.renderer.getConfig().getWindowOptions().getTitle());
        stage.setMaximized(this.renderer.getConfig().getWindowOptions().isFullscreen());
        stage.requestFocus();
        stage.show();
    }

    private void attachEventHandlers(Scene fxScene, Canvas fxCanvas) {
        fxScene.widthProperty().addListener((value, old, width) -> this.resizeWidth(fxCanvas, (Number)width));
        fxScene.heightProperty().addListener((value, old, height) -> this.resizeHeight(fxCanvas, (Number)height));
        fxScene.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> this.input.mouseEventQueue.add((MouseEvent)e));
        fxScene.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> this.input.mouseEventQueue.add((MouseEvent)e));
        fxScene.addEventFilter(MouseEvent.MOUSE_MOVED, e -> this.input.mouseEventQueue.add((MouseEvent)e));
        fxScene.addEventFilter(KeyEvent.KEY_PRESSED, e -> this.input.keyEventQueue.add((KeyEvent)e));
        fxScene.addEventFilter(KeyEvent.KEY_RELEASED, e -> this.input.keyEventQueue.add((KeyEvent)e));
    }

    private void startAnimationLoop() {
        AnimationTimer animationLoop = new AnimationTimer(){

            public void handle(long time) {
                if (!JFXAnimationLoop.this.handleFrameUpdate()) {
                    this.stop();
                }
            }
        };
        animationLoop.start();
    }

    private boolean handleFrameUpdate() {
        SceneManager sceneManager = this.renderer.getSceneManager();
        try {
            if (sceneManager.requestFrameUpdate() > 0) {
                sceneManager.getFrameStats().markStart("$$frameRender");
                this.renderer.getStage().visit(this.graphics);
                sceneManager.getFrameStats().markEnd("$$frameRender");
            }
            while (!this.renderer.getScreenshotQueue().isEmpty()) {
                this.takeScreenshot(this.renderer.getScreenshotQueue().removeFirst());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in JavaFX animation loop", e);
            this.renderer.getConfig().getErrorHandler().onError(this.renderer, e);
            return false;
        }
    }

    private void resizeWidth(Canvas fxCanvas, Number width) {
        int screenHeight = this.renderer.getCanvas().getScreenSize().height();
        this.renderer.getCanvas().resizeScreen(width.intValue(), screenHeight);
        fxCanvas.setWidth((double)width.intValue());
    }

    private void resizeHeight(Canvas fxCanvas, Number height) {
        int screenWidth = this.renderer.getCanvas().getScreenSize().width();
        this.renderer.getCanvas().resizeScreen(screenWidth, height.intValue());
        fxCanvas.setHeight((double)height.intValue());
    }

    private void takeScreenshot(File file) {
        WritableImage buffer = this.stage.getScene().snapshot(null);
        BufferedImage screenshot = new BufferedImage((int)Math.round(buffer.getWidth()), (int)Math.round(buffer.getHeight()), 2);
        int x = 0;
        while ((double)x < buffer.getWidth()) {
            int y = 0;
            while ((double)y < buffer.getHeight()) {
                screenshot.setRGB(x, y, buffer.getPixelReader().getArgb(x, y));
                ++y;
            }
            ++x;
        }
        try {
            Utils2D.savePNG((BufferedImage)screenshot, (File)file);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save screenshot", e);
        }
    }
}

