/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.math.Size;
import nl.colorize.multimedialib.math.Sphere;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.RendererException;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.renderer.libgdx.GDXGraphics;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXModel;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.TextUtils;
import nl.colorize.util.swing.SwingUtils;
import org.lwjgl.system.Configuration;

public class GDXRenderer
implements Renderer,
SceneContext,
ApplicationListener {
    private RenderConfig config;
    private Scene initialScene;
    private GDXGraphics graphics;
    private GDXInput input;
    private GDXMediaLoader mediaLoader;
    private Network network;
    private SceneManager sceneManager;
    private Stage stage;
    private static AtomicBoolean nativeLibrariesLoaded = new AtomicBoolean(false);
    private static final List<NativeLibrary> INTEL_MAC_NATIVE_LIBRARIES = List.of(new NativeLibrary("gdx", "libgdx64.dylib"), new NativeLibrary("lwjgl", "liblwjgl.dylib"), new NativeLibrary("lwjgl_opengl", "liblwjgl_opengl.dylib"), new NativeLibrary("lwjgl_stb", "liblwjgl_stb.dylib"), new NativeLibrary("glfw", "libglfw.dylib"), new NativeLibrary("glfw_async", "libglfw_async.dylib"), new NativeLibrary("openal", "libopenal.dylib"), new NativeLibrary("gdx-freetype", "libgdx-freetype64.dylib"));
    private static final List<NativeLibrary> ARM_MAC_NATIVE_LIBRARIES = List.of(new NativeLibrary("gdx", "libgdxarm64.dylib"), new NativeLibrary("lwjgl", "liblwjgl.dylib"), new NativeLibrary("lwjgl_opengl", "liblwjgl_opengl.dylib"), new NativeLibrary("lwjgl_stb", "liblwjgl_stb.dylib"), new NativeLibrary("glfw", "libglfw.dylib"), new NativeLibrary("glfw_async", "libglfw_async.dylib"), new NativeLibrary("openal", "libopenal.dylib"), new NativeLibrary("gdx-freetype", "libgdx-freetypearm64.dylib"));
    private static final int TEXTURE_FLAGS = 25;
    private static final int SPHERE_SEGMENTS = 32;
    private static final float HALF_PI = 1.5707964f;
    private static final Logger LOGGER = LogHelper.getLogger(GDXRenderer.class);

    public GDXRenderer() {
        if (Platform.isMac()) {
            Configuration.GLFW_LIBRARY_NAME.set((Object)"glfw_async");
        }
        if (Platform.isMacAppStore() && !nativeLibrariesLoaded.get()) {
            try {
                nativeLibrariesLoaded.set(true);
                this.loadApplicationBundleNativeLibraries();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while loading libGDX native libraries", e);
            }
        }
    }

    private void loadApplicationBundleNativeLibraries() throws Exception {
        LOGGER.info("Loading native libraries from Mac application bundle");
        LOGGER.info("Native library path: " + System.getProperty("java.library.path"));
        File nativeLibraryDir = Platform.getNativeLibraryPath().stream().filter(dir -> dir.getName().equalsIgnoreCase("MacOS")).findFirst().orElseThrow(() -> new RendererException("Cannot locate native libraries"));
        Function<String, String> lwjglMapper = lib -> this.locateNativeLWJGL((String)lib, nativeLibraryDir);
        Configuration.LIBRARY_PATH.set((Object)nativeLibraryDir.getAbsolutePath());
        Configuration.BUNDLED_LIBRARY_PATH_MAPPER.set(lwjglMapper);
        Configuration.BUNDLED_LIBRARY_NAME_MAPPER.set(lwjglMapper);
        Configuration.GLFW_LIBRARY_NAME.set((Object)lwjglMapper.apply("glfw_async"));
        GdxNativesLoader.disableNativesLoading = true;
        for (NativeLibrary lib2 : this.getMacNativeLibraries()) {
            SharedLibraryLoader.setLoaded((String)lib2.name);
            File dylib = new File(nativeLibraryDir, lib2.fileName);
            LOGGER.info("Loading native library " + lib2.name + " from " + dylib.getAbsolutePath());
            System.load(dylib.getAbsolutePath());
        }
    }

    private List<NativeLibrary> getMacNativeLibraries() {
        String cpuArchitecture = System.getProperty("os.arch", "");
        if (cpuArchitecture.contains("x86")) {
            return INTEL_MAC_NATIVE_LIBRARIES;
        }
        if (cpuArchitecture.contains("aarch")) {
            return ARM_MAC_NATIVE_LIBRARIES;
        }
        throw new RendererException("Unsupported Mac CPU architecture: " + cpuArchitecture);
    }

    private String locateNativeLWJGL(String lib, File nativeLibraryDir) {
        if (TextUtils.startsWith((String)(lib = lib.substring(lib.lastIndexOf("/") + 1)), List.of("lwjgl", "glfw", "openal"))) {
            lib = TextUtils.addLeading((String)lib, (String)"lib");
        }
        lib = TextUtils.addTrailing((String)lib, (String)".dylib");
        File dylib = new File(nativeLibraryDir, lib);
        LOGGER.info("Loading native LWJGL library " + dylib.getAbsolutePath());
        return dylib.getAbsolutePath();
    }

    @Override
    public void start(RenderConfig config, Scene initialScene) {
        this.config = config;
        this.initialScene = initialScene;
        try {
            Lwjgl3ApplicationConfiguration gdxConfig = this.configure();
            new Lwjgl3Application((ApplicationListener)this, gdxConfig);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during animation loop", e);
            config.getErrorHandler().onError(this, e);
        }
    }

    private Lwjgl3ApplicationConfiguration configure() {
        Lwjgl3ApplicationConfiguration gdxConfig = new Lwjgl3ApplicationConfiguration();
        gdxConfig.setIdleFPS(this.config.getFramerate());
        gdxConfig.setForegroundFPS(this.config.getFramerate());
        gdxConfig.setHdpiMode(HdpiMode.Logical);
        gdxConfig.setTitle(this.config.getWindowOptions().getTitle());
        gdxConfig.setWindowIcon(Files.FileType.Internal, new String[]{this.config.getWindowOptions().getIconFile().path()});
        if (this.config.getWindowOptions().isFullscreen()) {
            Dimension screen = SwingUtils.getScreenSize();
            gdxConfig.setDecorated(true);
            gdxConfig.setWindowedMode(screen.width, screen.height);
            gdxConfig.setMaximized(true);
        } else {
            gdxConfig.setDecorated(true);
            gdxConfig.setWindowedMode(this.getWindowSize().width(), this.getWindowSize().height());
        }
        return gdxConfig;
    }

    private Size getWindowSize() {
        Size windowSize = this.config.getWindowOptions().getWindowSize().orElse(this.config.getCanvas().getSize());
        if (Platform.isWindows()) {
            float uiScale = SwingUtils.getDesktopScaleFactor();
            windowSize = windowSize.multiply(uiScale);
        }
        return new Size(windowSize.width(), windowSize.height());
    }

    public void create() {
        this.input = new GDXInput(this.config);
        this.mediaLoader = new GDXMediaLoader();
        this.graphics = new GDXGraphics(this.config.getGraphicsMode(), this.config.getCanvas(), this.mediaLoader);
        this.network = new StandardNetwork();
        this.sceneManager = new SceneManager(this);
        this.stage = new Stage(this.config.getGraphicsMode(), this.config.getCanvas());
        this.resize(this.config.getCanvas().getWidth(), this.config.getCanvas().getHeight());
        this.changeScene(this.initialScene);
    }

    public void dispose() {
        this.graphics.dispose();
        this.mediaLoader.dispose();
        System.exit(0);
    }

    public void resize(int width, int height) {
        this.config.getCanvas().resizeScreen(width, height);
        HdpiUtils.glViewport((int)0, (int)0, (int)width, (int)height);
        this.graphics.restartBatch();
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        this.sceneManager.requestFrameUpdate();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16640);
        this.getFrameStats().markStart("$$frameRender");
        this.getStage().visit(this.graphics);
        this.getFrameStats().markEnd("$$frameRender");
    }

    @Override
    public void terminate() {
        System.exit(0);
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        Material material = this.createMaterial(color);
        Model model = this.buildModel(shape, material);
        return new GDXModel(model);
    }

    private Model buildModel(Shape3D shape, Material material) {
        if (shape instanceof Box) {
            Box box = (Box)shape;
            ModelBuilder modelBuilder = new ModelBuilder();
            Model boxModel = modelBuilder.createBox(box.depth(), box.width(), box.height(), material, 25L);
            Quaternion quaternionY = new Quaternion().setFromAxis(0.0f, 1.0f, 0.0f, 90.0f);
            Quaternion quaternionZ = new Quaternion().setFromAxis(1.0f, 0.0f, 0.0f, 90.0f);
            ((Node)boxModel.nodes.get((int)0)).rotation.set(quaternionY.mul(quaternionZ));
            return boxModel;
        }
        if (shape instanceof Sphere) {
            Sphere sphere = (Sphere)shape;
            ModelBuilder modelBuilder = new ModelBuilder();
            float diameter = sphere.radius() * 2.0f;
            return modelBuilder.createSphere(diameter, diameter, diameter, 32, 32, material, 25L);
        }
        throw new IllegalArgumentException("Unknown shape: " + String.valueOf(shape.getClass()));
    }

    private Material createMaterial(ColorRGB color) {
        ColorAttribute colorAttr = ColorAttribute.createDiffuse((Color)GDXMediaLoader.toColor(color));
        return new Material(new Attribute[]{colorAttr});
    }

    @Override
    public Point2D project(Point3D position) {
        Vector3 positionVector = new Vector3(position.x(), position.y(), position.z());
        Vector3 screenPosition = this.graphics.camera.project(positionVector);
        return new Point2D(this.getCanvas().toCanvasX(Math.round(screenPosition.x)), this.getCanvas().toCanvasY(Gdx.graphics.getHeight() - Math.round(screenPosition.y)));
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        float screenX = this.getCanvas().toScreenX(canvasPosition.x());
        float screenY = this.getCanvas().toScreenY(canvasPosition.y());
        BoundingBox boundingBox = new BoundingBox(new Vector3(area.x(), area.y(), area.z()), new Vector3(area.getEndX(), area.getEndY(), area.getEndZ()));
        Ray pickRay = this.graphics.camera.getPickRay(screenX, screenY);
        Vector3 intersection = new Vector3();
        return Intersector.intersectRayBounds((Ray)pickRay, (BoundingBox)boundingBox, (Vector3)intersection);
    }

    @Override
    public void takeScreenshot(File screenshotFile) {
        FileHandle file = Gdx.files.absolute(screenshotFile.getAbsolutePath());
        Pixmap screenshot = Pixmap.createFromFrameBuffer((int)0, (int)0, (int)Gdx.graphics.getBackBufferWidth(), (int)Gdx.graphics.getBackBufferHeight());
        PixmapIO.writePNG((FileHandle)file, (Pixmap)screenshot, (int)-1, (boolean)true);
        screenshot.dispose();
    }

    @Override
    public boolean isSupported(GraphicsMode graphicsMode) {
        return graphicsMode == GraphicsMode.MODE_2D || graphicsMode == GraphicsMode.MODE_3D;
    }

    @Override
    public String getRendererName() {
        return "libGDX renderer";
    }

    @Override
    @Generated
    public RenderConfig getConfig() {
        return this.config;
    }

    @Override
    @Generated
    public GDXInput getInput() {
        return this.input;
    }

    @Override
    @Generated
    public GDXMediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    @Generated
    public Network getNetwork() {
        return this.network;
    }

    @Override
    @Generated
    public SceneManager getSceneManager() {
        return this.sceneManager;
    }

    @Override
    @Generated
    public Stage getStage() {
        return this.stage;
    }

    private record NativeLibrary(String name, String fileName) {
    }
}

