/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RendererException;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.PixiBridge;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.FontFace;
import nl.colorize.multimedialib.stage.Group;
import nl.colorize.multimedialib.stage.ImageTransform;
import nl.colorize.multimedialib.stage.Light;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.multimedialib.stage.StageSubscriber;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.util.TextUtils;
import nl.colorize.util.stats.Cache;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLImageElement;

public class PixiGraphics
implements TeaGraphics,
StageSubscriber {
    private Canvas canvas;
    private TeaMediaLoader mediaLoader;
    private PixiBridge pixi;
    private Map<StageNode2D, PixiBridge.PixiDisplayObject> displayObjects = new HashMap<StageNode2D, PixiBridge.PixiDisplayObject>();
    private Cache<TeaImage, PixiBridge.PixiTexture> textureCache = Cache.from(this::prepareTexture, (int)2048);
    private static final int TEXTURE_CACHE_SIZE = 2048;

    @Override
    public void init(SceneContext context) {
        this.canvas = context.getCanvas();
        this.mediaLoader = (TeaMediaLoader)context.getMediaLoader();
        this.pixi = Browser.getPixiBridge();
        this.pixi.init();
        Container rootContainer = context.getStage().getRoot();
        this.displayObjects.put(rootContainer, this.pixi.getRootContainer());
    }

    private PixiBridge.PixiRectangle getScreen() {
        return this.pixi.getPixiApp().getScreen();
    }

    @Override
    public int getDisplayWidth() {
        return Math.round(this.getScreen().getWidth());
    }

    @Override
    public int getDisplayHeight() {
        return Math.round(this.getScreen().getHeight());
    }

    @Override
    public float getDevicePixelRatio() {
        return 1.0f;
    }

    @Override
    public void onNodeAdded(Container parent, StageNode2D node) {
        PixiBridge.PixiDisplayObject parentDisplayObject = this.displayObjects.get(parent);
        PixiBridge.PixiDisplayObject displayObject = this.createDisplayObject(node);
        parentDisplayObject.addChild(displayObject);
        this.displayObjects.put(node, displayObject);
    }

    @Override
    public void onNodeRemoved(Container parent, StageNode2D node) {
        PixiBridge.PixiDisplayObject parentDisplayObject = this.displayObjects.get(parent);
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(node);
        parentDisplayObject.removeChild(displayObject);
        this.displayObjects.remove(node);
    }

    @Override
    public void prepareStage(Stage stage) {
    }

    @Override
    public void visitContainer(Container container, Transform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.displayObjects.get(container);
        displayObject.setVisible(container.getTransform().isVisible());
    }

    @Override
    public boolean shouldVisitAllNodes() {
        return true;
    }

    private PixiBridge.PixiDisplayObject createDisplayObject(StageNode2D graphic) {
        PixiBridge.PixiDisplayObject existing = this.displayObjects.get(graphic);
        if (existing != null) {
            return existing;
        }
        StageNode2D stageNode2D = graphic;
        Objects.requireNonNull(stageNode2D);
        StageNode2D stageNode2D2 = stageNode2D;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class, Sprite.class, Primitive.class, Text.class}, (Object)stageNode2D2, n)) {
            case 0 -> {
                Container container = (Container)stageNode2D2;
                yield this.pixi.createContainer();
            }
            case 1 -> {
                Sprite sprite = (Sprite)stageNode2D2;
                yield this.createSpriteDisplayObject(sprite);
            }
            case 2 -> {
                Primitive primitive = (Primitive)stageNode2D2;
                yield this.pixi.createGraphics();
            }
            case 3 -> {
                Text text = (Text)stageNode2D2;
                yield this.createTextDisplayObject(text);
            }
            default -> throw new RendererException("Unknown graphics type: " + String.valueOf(graphic));
        };
    }

    private PixiBridge.PixiDisplayObject createSpriteDisplayObject(Sprite sprite) {
        TeaImage image = this.getImage(sprite);
        PixiBridge.PixiDisplayObject spriteContainer = this.pixi.createContainer();
        image.getImagePromise().subscribe(imageElement -> {
            PixiBridge.PixiTexture texture = (PixiBridge.PixiTexture)this.textureCache.get((Object)image);
            PixiBridge.PixiDisplayObject spriteDisplayObject = this.pixi.createSprite(texture);
            spriteContainer.addChild(spriteDisplayObject);
        });
        return spriteContainer;
    }

    private PixiBridge.PixiDisplayObject createTextDisplayObject(Text text) {
        FontFace scaledFont = text.getFont().scale(this.canvas);
        return this.pixi.createText(scaledFont.family(), scaledFont.size(), false, text.getAlign().toString(), text.getLineHeight(), scaledFont.color().getRGB());
    }

    private TeaImage getImage(Sprite sprite) {
        return (TeaImage)sprite.getCurrentGraphics();
    }

    private PixiBridge.PixiTexture prepareTexture(TeaImage image) {
        Preconditions.checkState((boolean)image.isLoaded(), (Object)"Image is still loading");
        HTMLImageElement imgElement = image.getImageElement().get();
        Region region = image.getRegion();
        return this.pixi.createTexture(image.getId().toString(), (CanvasImageSource)imgElement, region.x(), region.y(), region.width(), region.height());
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.pixi.changeBackgroundColor(color.getRGB());
    }

    private PixiBridge.PixiDisplayObject getDisplayObject(StageNode2D graphic) {
        PixiBridge.PixiDisplayObject displayObject = this.displayObjects.get(graphic);
        if (displayObject == null) {
            throw new RendererException("Creating unexpected display object for " + String.valueOf(graphic));
        }
        displayObject.setVisible(graphic.getTransform().isVisible());
        return displayObject;
    }

    @Override
    public void drawSprite(Sprite sprite, ImageTransform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(sprite);
        PixiBridge.PixiDisplayObject[] containerContents = displayObject.getChildren();
        if (containerContents.length == 0) {
            return;
        }
        PixiBridge.PixiDisplayObject spriteDisplayObject = containerContents[0];
        this.updateSprite(sprite, globalTransform, spriteDisplayObject);
    }

    private void updateSprite(Sprite sprite, ImageTransform transform, PixiBridge.PixiDisplayObject displayObject) {
        TeaImage image = this.getImage(sprite);
        float zoom = this.canvas.getZoomLevel();
        displayObject.setX(this.toScreenX(transform.getPosition()));
        displayObject.setY(this.toScreenY(transform.getPosition()));
        displayObject.setAlpha(transform.getAlpha() / 100.0f);
        displayObject.setAngle(transform.getRotation().degrees());
        displayObject.getScale().setX(transform.getScaleX() * zoom / 100.0f);
        displayObject.getScale().setY(transform.getScaleY() * zoom / 100.0f);
        if (!displayObject.isTintEnabled()) {
            this.updateTexture(displayObject, image);
        }
        this.updateTextureRegion(displayObject, image.getRegion());
        this.updateMask(displayObject, image, transform.getMaskColor());
    }

    private void updateTexture(PixiBridge.PixiDisplayObject sprite, TeaImage image) {
        PixiBridge.PixiTexture texture = sprite.getTexture();
        if (!image.getId().toString().equals(texture.getTextureImageId())) {
            PixiBridge.PixiTexture newTexture = (PixiBridge.PixiTexture)this.textureCache.get((Object)image);
            sprite.setTexture(newTexture);
        }
    }

    private void updateTextureRegion(PixiBridge.PixiDisplayObject sprite, Region region) {
        PixiBridge.PixiTexture texture = sprite.getTexture();
        PixiBridge.PixiRectangle frame = texture.getFrame();
        frame.setX(region.x());
        frame.setY(region.y());
        frame.setWidth(region.width());
        frame.setHeight(region.height());
        texture.updateUvs();
    }

    private void updateMask(PixiBridge.PixiDisplayObject sprite, TeaImage image, ColorRGB mask) {
        if (!sprite.isTintEnabled() && mask != null) {
            HTMLCanvasElement maskImage = this.mediaLoader.applyMask(image, mask);
            Region region = image.getRegion();
            UUID maskImageId = UUID.randomUUID();
            PixiBridge.PixiTexture maskTexture = this.pixi.createTexture(maskImageId.toString(), (CanvasImageSource)maskImage, region.x(), region.y(), region.width(), region.height());
            sprite.setTintEnabled(true);
            sprite.setOriginalTexture(sprite.getTexture());
            sprite.setTexture(maskTexture);
        } else if (sprite.isTintEnabled() && mask == null) {
            sprite.setTintEnabled(false);
            sprite.setTexture(sprite.getOriginalTexture());
        }
    }

    @Override
    public void drawLine(Primitive graphic, Line line, Transform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(graphic);
        displayObject.clear();
        displayObject.lineStyle(Math.round(graphic.getStroke()), graphic.getColor().getRGB());
        displayObject.moveTo(this.toScreenX(line.start()), this.toScreenY(line.start()));
        displayObject.lineTo(this.toScreenX(line.end()), this.toScreenY(line.end()));
        displayObject.setAlpha(globalTransform.getAlpha() / 100.0f);
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line, Transform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(graphic);
        displayObject.clear();
        displayObject.lineStyle(Math.round(graphic.getStroke()), graphic.getColor().getRGB());
        displayObject.moveTo(this.toScreenX(line.getHead()), this.toScreenY(line.getHead()));
        for (Point2D p : line.points()) {
            displayObject.lineTo(this.toScreenX(p), this.toScreenY(p));
        }
        displayObject.setAlpha(globalTransform.getAlpha() / 100.0f);
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect, Transform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(graphic);
        displayObject.clear();
        displayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        displayObject.drawRect(this.toScreenX(rect.x()), this.toScreenY(rect.y()), rect.width() * this.canvas.getZoomLevel(), rect.height() * this.canvas.getZoomLevel());
        displayObject.endFill();
        displayObject.setAlpha(globalTransform.getAlpha() / 100.0f);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle, Transform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(graphic);
        displayObject.clear();
        displayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        displayObject.drawCircle(this.toScreenX(circle.center().x()), this.toScreenY(circle.center().y()), circle.radius() * this.canvas.getZoomLevel());
        displayObject.endFill();
        displayObject.setAlpha(globalTransform.getAlpha() / 100.0f);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon, Transform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(graphic);
        float[] points = new float[polygon.getNumPoints() * 2];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            points[i * 2] = this.toScreenX(polygon.getPointX(i));
            points[i * 2 + 1] = this.toScreenY(polygon.getPointY(i));
        }
        displayObject.clear();
        displayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        displayObject.drawPolygon(points);
        displayObject.endFill();
        displayObject.setAlpha(globalTransform.getAlpha() / 100.0f);
    }

    @Override
    public void drawText(Text text, Transform globalTransform) {
        PixiBridge.PixiDisplayObject displayObject = this.getDisplayObject(text);
        float offset = -0.65f * text.getLineHeight();
        displayObject.setText(TextUtils.LINE_JOINER.join(text.getLines()));
        displayObject.setX(this.toScreenX(globalTransform.getPosition()));
        displayObject.setY(this.toScreenY(globalTransform.getPosition().y() + offset));
        displayObject.setAlpha(globalTransform.getAlpha() / 100.0f);
    }

    @Override
    public void visitGroup(Group group, Transform3D globalTransform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawMesh(Mesh mesh, Transform3D globalTransform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawLight(Light light, Transform3D globalTransform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2D project(Point3D position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        throw new UnsupportedOperationException();
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.canvas.toScreenX(point.x());
    }

    private float toScreenY(float y) {
        return this.canvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.canvas.toScreenY(point.y());
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }
}

