/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import lombok.Generated;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Subject;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.canvas.ImageData;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLImageElement;
import org.teavm.jso.typedarrays.Uint8ClampedArray;

public class TeaImage
implements Image {
    private UUID id = UUID.randomUUID();
    private Subject<HTMLImageElement> imagePromise;
    private Region region;
    private HTMLImageElement imageElement;
    private CanvasRenderingContext2D imageData;
    public static final Region IMAGE_LOADING_REGION = new Region(0, 0, 1, 1);
    private static final int[] UNKNOWN_RGBA = new int[]{0, 0, 0, 0};
    private static final Logger LOGGER = LogHelper.getLogger(TeaImage.class);

    protected TeaImage(Subject<HTMLImageElement> imagePromise, Region region) {
        this.imagePromise = imagePromise;
        this.region = region;
        imagePromise.subscribe(event -> {
            this.imageElement = event;
        });
    }

    public Optional<HTMLImageElement> getImageElement() {
        return Optional.ofNullable(this.imageElement);
    }

    public boolean isLoaded() {
        return this.imageElement != null;
    }

    @Override
    public Region getRegion() {
        if (this.region == null) {
            if (this.imageElement == null) {
                return IMAGE_LOADING_REGION;
            }
            this.region = new Region(0, 0, this.imageElement.getWidth(), this.imageElement.getHeight());
        }
        return this.region;
    }

    @Override
    public TeaImage extractRegion(Region subRegion) {
        if (this.region != null) {
            subRegion = subRegion.move(this.region.x(), this.region.y());
        }
        return new TeaImage(this.imagePromise, subRegion);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return new ColorRGB(rgba[0], rgba[1], rgba[2]);
    }

    @Override
    public int getAlpha(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return Math.round((float)rgba[3] / 2.55f);
    }

    private int[] getImageData(int x, int y) {
        if (this.imageElement == null) {
            LOGGER.warning("Trying to retrieve image data when image is still loading");
            return UNKNOWN_RGBA;
        }
        Region region = this.getRegion();
        if (this.imageData == null) {
            HTMLDocument document = Window.current().getDocument();
            HTMLCanvasElement canvas = (HTMLCanvasElement)document.createElement("canvas");
            canvas.setWidth(region.width());
            canvas.setHeight(region.height());
            this.imageData = (CanvasRenderingContext2D)canvas.getContext("2d");
            this.imageData.drawImage((CanvasImageSource)this.imageElement, (double)(-region.x()), (double)(-region.y()));
        }
        ImageData pixels = this.imageData.getImageData((double)x, (double)y, 1.0, 1.0);
        Uint8ClampedArray pixelData = pixels.getData();
        return new int[]{pixelData.get(0), pixelData.get(1), pixelData.get(2), pixelData.get(3)};
    }

    public TeaImage forParentImage() {
        Preconditions.checkState((boolean)this.isLoaded(), (Object)"Image is still loading");
        if (this.region == null) {
            return this;
        }
        return new TeaImage(this.imagePromise, null);
    }

    public boolean isFullImage() {
        return this.region == null;
    }

    public String toString() {
        if (this.imageElement == null) {
            return "<loading>";
        }
        return this.imageElement.getSrc();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Subject<HTMLImageElement> getImagePromise() {
        return this.imagePromise;
    }
}

