/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.Map;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.PeerConnection;
import nl.colorize.multimedialib.renderer.Response;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.PeerjsBridge;
import nl.colorize.multimedialib.renderer.teavm.PeerjsConnection;
import nl.colorize.util.EventQueue;
import nl.colorize.util.LogHelper;
import nl.colorize.util.http.HttpException;
import nl.colorize.util.stats.TupleList;
import org.jspecify.annotations.Nullable;
import org.teavm.jso.ajax.XMLHttpRequest;

public class TeaNetwork
implements Network {
    private static final Splitter HEADER_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n"));
    private static final Logger LOGGER = LogHelper.getLogger(TeaNetwork.class);

    @Override
    public EventQueue<Response> send(String method, String url, Map<String, String> headers, @Nullable String body) {
        XMLHttpRequest request = XMLHttpRequest.create();
        EventQueue eventQueue = new EventQueue();
        request.setOnReadyStateChange(() -> this.handleResponse(request, (EventQueue<Response>)eventQueue));
        request.open(method, url, true);
        this.addRequestHeaders(request, headers);
        if (body != null && !body.isEmpty()) {
            request.send(body);
        } else {
            request.send();
        }
        return eventQueue;
    }

    private void addRequestHeaders(XMLHttpRequest request, Map<String, String> headers) {
        request.setRequestHeader("X-Requested-With", "MultimediaLib");
        headers.forEach((arg_0, arg_1) -> ((XMLHttpRequest)request).setRequestHeader(arg_0, arg_1));
    }

    private void handleResponse(XMLHttpRequest request, EventQueue<Response> eventQueue) {
        if (request.getReadyState() == 4) {
            if (request.getStatus() >= 200 && request.getStatus() <= 204) {
                eventQueue.onNext((Object)this.mapResponse(request));
            } else {
                HttpException error = new HttpException("AJAX request failed: " + request.getStatusText(), request.getStatus());
                eventQueue.onError((Throwable)error);
            }
        }
    }

    private Response mapResponse(XMLHttpRequest request) {
        int status = request.getStatus();
        TupleList headers = new TupleList();
        String body = request.getResponseText();
        for (String line : HEADER_SPLITTER.split((CharSequence)request.getAllResponseHeaders())) {
            if (line.contains(": ")) {
                String name = line.substring(0, line.indexOf(": "));
                String value = line.substring(line.indexOf(": ") + 2);
                headers.add((Object)name, (Object)value);
                continue;
            }
            if (line.isEmpty()) continue;
            LOGGER.warning("Malformed HTTP response header: " + line);
        }
        return new Response(status, (TupleList<String, String>)headers, body);
    }

    @Override
    public PeerConnection openPeerConnection() {
        PeerjsBridge bridge = Browser.getPeerJsBridge();
        return new PeerjsConnection(bridge);
    }

    @Override
    public boolean isPeerToPeerSupported() {
        return true;
    }
}

