/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.annotations.Beta;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.math.Sphere;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.HtmlCanvasGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.ThreeBridge;
import nl.colorize.multimedialib.renderer.teavm.ThreeMeshWrapper;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Group;
import nl.colorize.multimedialib.stage.ImageTransform;
import nl.colorize.multimedialib.stage.Light;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageNode3D;
import nl.colorize.multimedialib.stage.StageSubscriber;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.Transform3D;
import nl.colorize.util.Subject;

@Beta
public class ThreeGraphics
implements TeaGraphics,
StageSubscriber {
    private Canvas canvas;
    private TeaMediaLoader mediaLoader;
    private ThreeBridge three;
    private HtmlCanvasGraphics overlay;
    private Map<StageNode3D, ThreeBridge.ThreeObject> threeObjects;
    private Map<Light, ThreeBridge.ThreeLight> lights;
    private static final float PI = (float)Math.PI;

    @Override
    public void init(SceneContext context) {
        this.canvas = context.getCanvas();
        this.mediaLoader = (TeaMediaLoader)context.getMediaLoader();
        this.threeObjects = new HashMap<StageNode3D, ThreeBridge.ThreeObject>();
        this.lights = new HashMap<Light, ThreeBridge.ThreeLight>();
        this.three = Browser.getThreeBridge();
        this.three.init();
        this.overlay = new HtmlCanvasGraphics();
        this.overlay.init(context);
        this.overlay.getHtmlCanvas().getStyle().setProperty("position", "absolute");
        this.overlay.getHtmlCanvas().getStyle().setProperty("left", "0");
        this.overlay.getHtmlCanvas().getStyle().setProperty("top", "0");
        this.overlay.getHtmlCanvas().getStyle().setProperty("z-index", "2");
        context.getStage().subscribe(this);
    }

    @Override
    public int getDisplayWidth() {
        return this.overlay.getDisplayWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this.overlay.getDisplayHeight();
    }

    @Override
    public void onNodeAdded(Group parent, StageNode3D node) {
        if (node instanceof Light) {
            Light light = (Light)node;
            ThreeBridge.ThreeLight threeLight = this.three.createLight(light.getColor().toHex(), light.getIntensity());
            this.three.getScene().add(threeLight);
            this.lights.put(light, threeLight);
        }
    }

    @Override
    public void onNodeRemoved(Group parent, StageNode3D node) {
        ThreeBridge.ThreeObject threeObject = this.threeObjects.get(node);
        if (threeObject != null) {
            threeObject.removeFromParent();
        }
        if (node instanceof Light) {
            Light light = (Light)node;
            ThreeBridge.ThreeLight threeLight = this.lights.get(light);
            threeLight.removeFromParent();
            this.lights.remove(light);
        }
    }

    @Override
    public void prepareStage(Stage stage) {
        Point3D camera = stage.getCameraPosition();
        Point3D focus = stage.getCameraFocus();
        this.three.moveCamera(camera.x(), camera.y(), camera.z(), focus.x(), focus.y(), focus.z());
        ThreeBridge.ThreeLight ambientLight = this.three.getAmbientLight();
        ambientLight.getColor().set(stage.getAmbientLightColor().toHex());
        this.overlay.prepareStage(stage);
    }

    @Override
    public boolean shouldVisitAllNodes() {
        return true;
    }

    @Override
    public void visitContainer(Container container, Transform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.visitContainer(container, globalTransform);
        }
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.three.changeBackgroundColor(color.toHex());
    }

    @Override
    public void drawSprite(Sprite sprite, ImageTransform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.drawSprite(sprite, globalTransform);
        }
    }

    @Override
    public void drawLine(Primitive graphic, Line line, Transform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.drawLine(graphic, line, globalTransform);
        }
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line, Transform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.drawSegmentedLine(graphic, line, globalTransform);
        }
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect, Transform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.drawRect(graphic, rect, globalTransform);
        }
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle, Transform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.drawCircle(graphic, circle, globalTransform);
        }
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon, Transform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.drawPolygon(graphic, polygon, globalTransform);
        }
    }

    @Override
    public void drawText(Text text, Transform globalTransform) {
        if (globalTransform.isVisible()) {
            this.overlay.drawText(text, globalTransform);
        }
    }

    @Override
    public void visitGroup(Group group, Transform3D globalTransform) {
    }

    @Override
    public void drawMesh(Mesh mesh, Transform3D globalTransform) {
        ThreeMeshWrapper meshWrapper = (ThreeMeshWrapper)mesh;
        ThreeBridge.ThreeObject threeObject = meshWrapper.getThreeObject();
        if (threeObject == null) {
            return;
        }
        if (!this.threeObjects.containsKey(meshWrapper)) {
            this.threeObjects.put(meshWrapper, threeObject);
            this.three.getScene().add(threeObject);
        }
        this.syncTransform(threeObject, globalTransform);
    }

    @Override
    public void drawLight(Light light, Transform3D globalTransform) {
        Point3D position = globalTransform.getPosition();
        ThreeBridge.ThreeLight threeLight = this.lights.get(light);
        this.syncTransform(threeLight, globalTransform);
        threeLight.getPosition().set(position.x(), position.y(), position.z());
        threeLight.getColor().set(light.getColor().toHex());
        threeLight.setIntensity(globalTransform.isVisible() ? light.getIntensity() : 0.0f);
    }

    private void syncTransform(ThreeBridge.ThreeObject threeObject, Transform3D globalTransform) {
        Point3D position = globalTransform.getPosition();
        threeObject.setVisible(globalTransform.isVisible());
        threeObject.getPosition().set(position.x(), position.y(), position.z());
        threeObject.getRotation().set(globalTransform.getRotationX().getRadians(), globalTransform.getRotationY().getRadians(), globalTransform.getRotationZ().getRadians());
        threeObject.getScale().set(globalTransform.getScaleX() / 100.0f, globalTransform.getScaleY() / 100.0f, globalTransform.getScaleZ() / 100.0f);
    }

    @Override
    public Mesh createMesh(Shape3D shape, ColorRGB color) {
        if (shape instanceof Box) {
            Box box = (Box)shape;
            ThreeBridge.ThreeObject model = this.three.createBox(box.width(), box.height(), box.depth(), color.toHex());
            return new ThreeMeshWrapper((Subject<ThreeBridge.ThreeObject>)Subject.of((Object[])new ThreeBridge.ThreeObject[]{model}));
        }
        if (shape instanceof Sphere) {
            Sphere sphere = (Sphere)shape;
            ThreeBridge.ThreeObject model = this.three.createSphere(sphere.radius(), color.toHex());
            return new ThreeMeshWrapper((Subject<ThreeBridge.ThreeObject>)Subject.of((Object[])new ThreeBridge.ThreeObject[]{model}));
        }
        throw new IllegalArgumentException("Unknown shape: " + String.valueOf(shape));
    }

    @Override
    public Point2D project(Point3D position) {
        ThreeBridge.ThreeVector ndcPosition = this.three.project(position.x(), position.y(), position.z());
        float canvasX = (ndcPosition.getX() + 1.0f) / 2.0f * (float)this.canvas.getWidth();
        float canvasY = (-ndcPosition.getY() + 1.0f) / 2.0f * (float)this.canvas.getHeight();
        return new Point2D(canvasX, canvasY);
    }

    @Override
    public boolean castPickRay(Point2D canvasPosition, Box area) {
        float ndcX = canvasPosition.x() / (float)this.canvas.getWidth() * 2.0f - 1.0f;
        float ndcY = -(canvasPosition.y() / (float)this.canvas.getHeight()) * 2.0f + 1.0f;
        return this.three.castPickRay(ndcX, ndcY, area.x(), area.y(), area.z(), area.getEndX(), area.getEndY(), area.getEndZ());
    }

    @Override
    public void finalize3D(Stage stage) {
        this.three.render();
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_3D;
    }
}

