/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.function.BooleanSupplier;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Updatable;

public class FluentScene
implements Scene {
    private Updatable onFrame;
    private BooleanSupplier completed;
    private Runnable onComplete;

    public FluentScene(Updatable onFrame) {
        this.onFrame = onFrame;
    }

    public FluentScene withCompletion(BooleanSupplier completed, Runnable onComplete) {
        this.completed = completed;
        this.onComplete = onComplete;
        return this;
    }

    public FluentScene withCompletion(BooleanSupplier completed) {
        return this.withCompletion(completed, null);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        this.onFrame.update(deltaTime);
    }

    @Override
    public void end(SceneContext context) {
        if (this.onComplete != null) {
            this.onComplete.run();
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed != null && this.completed.getAsBoolean();
    }
}

