/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import nl.colorize.multimedialib.math.Box;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Shape3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.RenderConfig;
import nl.colorize.multimedialib.scene.FluentScene;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Mesh;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.util.EventQueue;
import nl.colorize.util.Subject;
import nl.colorize.util.animation.Timeline;

public interface SceneContext {
    public RenderConfig getConfig();

    default public Canvas getCanvas() {
        return this.getConfig().getCanvas();
    }

    public MediaLoader getMediaLoader();

    public InputDevice getInput();

    public Network getNetwork();

    public SceneManager getSceneManager();

    public Stage getStage();

    default public FrameStats getFrameStats() {
        return this.getSceneManager().getFrameStats();
    }

    default public void changeScene(Scene requestedScene) {
        this.getSceneManager().changeScene(requestedScene);
    }

    default public void attach(Scene subScene) {
        this.getSceneManager().attach(subScene);
    }

    default public void attach(Updatable onFrame, BooleanSupplier completed, Runnable onComplete) {
        FluentScene subScene = new FluentScene(onFrame).withCompletion(completed, onComplete);
        this.getSceneManager().attach(subScene);
    }

    default public void attach(Updatable callback) {
        Scene subScene = (context, deltaTime) -> callback.update(deltaTime);
        this.attach(subScene);
    }

    default public void attach(Runnable callback) {
        Scene subScene = (context, deltaTime) -> callback.run();
        this.attach(subScene);
    }

    default public <T> void attach(EventQueue<T> events, Consumer<T> onEvent, Consumer<Exception> onError) {
        this.attach(() -> events.flush(onEvent, onError));
    }

    default public <T> Subject<T> attach(EventQueue<T> eventQueue) {
        Subject frameUpdateSubject = new Subject();
        this.attach(() -> eventQueue.flush(arg_0 -> ((Subject)frameUpdateSubject).next(arg_0), arg_0 -> ((Subject)frameUpdateSubject).nextError(arg_0)));
        return frameUpdateSubject;
    }

    default public void attachTimer(Timer timer, Runnable callback) {
        this.attach(timer, timer::isCompleted, callback);
    }

    default public void attachTimer(float delay, Runnable callback) {
        this.attachTimer(new Timer(delay), callback);
    }

    default public void attachTimeline(Timeline timeline, Consumer<Float> callback, Runnable onComplete) {
        Updatable frameHandler = deltaTime -> {
            timeline.movePlayhead(deltaTime);
            callback.accept(Float.valueOf(timeline.getValue()));
        };
        BooleanSupplier completionCheck = () -> timeline.isCompleted() && !timeline.isLoop();
        this.attach(frameHandler, completionCheck, onComplete);
    }

    default public void attachTimeline(Timeline timeline, Consumer<Float> callback) {
        this.attachTimeline(timeline, callback, null);
    }

    default public void attachClickHandler(StageNode2D node, Runnable callback) {
        this.attach(() -> {
            if (this.getInput().isPointerReleased(node)) {
                callback.run();
            }
        });
    }

    default public void attachGlobalSubScene(Scene globalSubScene) {
        this.getSceneManager().attachGlobalSubScene(globalSubScene);
    }

    public Mesh createMesh(Shape3D var1, ColorRGB var2);

    default public Mesh createMesh(Shape3D shape) {
        return this.createMesh(shape, ColorRGB.WHITE);
    }

    public Point2D project(Point3D var1);

    public boolean castPickRay(Point2D var1, Box var2);

    public void takeScreenshot(File var1);

    public void terminate();

    public String getRendererName();

    default public List<String> getDebugInformation() {
        FrameStats frameStats = this.getSceneManager().getFrameStats();
        int targetFPS = this.getConfig().getFramerate();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Renderer:  " + this.getRendererName());
        info.add("Canvas:  " + String.valueOf(this.getCanvas()));
        info.add("Framerate:  " + Math.round(frameStats.getAverageFramerate()) + " / " + targetFPS);
        info.add("Update time:  " + frameStats.getFrameUpdateTime() + "ms");
        info.add("Render time:  " + frameStats.getFrameRenderTime() + "ms");
        if (!frameStats.getCustomStats().isEmpty()) {
            info.add("");
        }
        for (String customStat : frameStats.getCustomStats()) {
            info.add(customStat + ":  " + frameStats.getAverageTimeMS(customStat) + "ms");
        }
        return info;
    }
}

