/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import lombok.Generated;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.util.Stopwatch;

public class SceneManager {
    private SceneContext context;
    private Stopwatch timer;
    private long elapsedTime;
    private FrameStats frameStats;
    private SceneState activeScene;
    private Queue<SceneState> requestedSceneQueue;
    private List<Scene> globalSubScenes;
    private static final long FRAME_LEEWAY_MS = 5L;
    private static final float MIN_FRAME_TIME = 0.01f;
    private static final float MAX_FRAME_TIME = 0.2f;

    public SceneManager(SceneContext context, Stopwatch timer) {
        this.context = context;
        this.timer = timer;
        this.elapsedTime = 0L;
        this.frameStats = new FrameStats();
        this.requestedSceneQueue = new LinkedList<SceneState>();
        this.globalSubScenes = new ArrayList<Scene>();
    }

    public SceneManager(SceneContext context) {
        this(context, new Stopwatch());
    }

    public int requestFrameUpdate() {
        long frameTime = this.timer.tick();
        this.elapsedTime += frameTime;
        long targetFrameTime = Math.round(1000.0f / (float)this.context.getConfig().getFramerate());
        if (this.elapsedTime < targetFrameTime - 5L) {
            return 0;
        }
        this.frameStats.markEnd("$$frameTime");
        float deltaTime = Math.clamp((float)this.elapsedTime / 1000.0f, 0.01f, 0.2f);
        this.frameStats.markStart("$$frameUpdate");
        this.performFrameUpdate(deltaTime);
        this.frameStats.markEnd("$$frameUpdate");
        this.elapsedTime = 0L;
        return 1;
    }

    protected void performFrameUpdate(float deltaTime) {
        this.updateInput(this.context.getInput(), deltaTime);
        if (!this.requestedSceneQueue.isEmpty()) {
            this.activateRequestedScene();
        }
        this.updateCurrentScene(this.activeScene, deltaTime);
        this.updateGlobalSubScenes(deltaTime);
    }

    private void updateInput(InputDevice input, float deltaTime) {
        if (!(input instanceof Renderer)) {
            input.update(deltaTime);
        }
        for (Pointer pointer : input.getPointers()) {
            pointer.update(deltaTime);
        }
    }

    private void updateCurrentScene(SceneState current, float deltaTime) {
        current.scene.update(this.context, deltaTime);
        for (Scene subScene : current.subScenes) {
            if (this.checkCompleted(current, subScene)) continue;
            subScene.update(this.context, deltaTime);
            this.checkCompleted(current, subScene);
        }
        this.context.getStage().getAnimationTimer().update(deltaTime);
    }

    private boolean checkCompleted(SceneState parent, Scene subScene) {
        if (subScene.isCompleted()) {
            subScene.end(this.context);
            parent.subScenes.remove(subScene);
            return true;
        }
        return false;
    }

    private void activateRequestedScene() {
        SceneState requestedScene;
        if (this.activeScene != null) {
            this.activeScene.walk(scene -> scene.end(this.context));
            this.context.getStage().clear();
            this.context.getStage().getAnimationTimer().reset();
        }
        if ((requestedScene = this.requestedSceneQueue.peek()) != null) {
            this.activeScene = requestedScene;
            this.activeScene.walk(scene -> scene.start(this.context));
            this.requestedSceneQueue.poll();
            if (!this.requestedSceneQueue.isEmpty()) {
                this.activateRequestedScene();
            }
        }
    }

    private void updateGlobalSubScenes(float deltaTime) {
        Iterator<Scene> iterator = this.globalSubScenes.iterator();
        while (iterator.hasNext()) {
            Scene globalScene = iterator.next();
            globalScene.update(this.context, deltaTime);
            if (!globalScene.isCompleted()) continue;
            iterator.remove();
        }
    }

    public void changeScene(Scene requestedScene) {
        this.requestedSceneQueue.offer(new SceneState(requestedScene));
    }

    public void attach(Scene subScene) {
        if (this.requestedSceneQueue.isEmpty()) {
            this.activeScene.subScenes.add(subScene);
            subScene.start(this.context);
        } else {
            SceneState requestedScene = this.requestedSceneQueue.peek();
            requestedScene.subScenes.add(subScene);
        }
    }

    public void attachGlobalSubScene(Scene globalSubScene) {
        this.globalSubScenes.add(globalSubScene);
        globalSubScene.start(this.context);
    }

    public boolean isActiveScene(Scene scene) {
        if (this.activeScene == null) {
            return false;
        }
        if (this.activeScene.scene.equals(scene)) {
            return true;
        }
        return this.activeScene.subScenes.stream().anyMatch(subScene -> subScene.equals(scene));
    }

    @Generated
    public FrameStats getFrameStats() {
        return this.frameStats;
    }

    private static class SceneState {
        private Scene scene;
        private List<Scene> subScenes;

        public SceneState(Scene scene) {
            this.scene = scene;
            this.subScenes = new CopyOnWriteArrayList<Scene>();
        }

        public void walk(Consumer<Scene> callback) {
            callback.accept(this.scene);
            this.subScenes.forEach(callback);
        }
    }
}

