/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.Deque;
import java.util.LinkedList;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;

public class StateMachine<S>
implements Updatable {
    private Deque<StateQueueElement<S>> stateQueue = new LinkedList<StateQueueElement<S>>();
    private StateQueueElement<S> defaultState;

    public StateMachine(S defaultState) {
        this.defaultState = new StateQueueElement<S>(defaultState, Timer.infinite(), true);
    }

    public boolean requestState(S nextState) {
        return this.requestState(nextState, 0.0f);
    }

    public boolean requestState(S nextState, float duration) {
        if (!this.isTransitionAllowed(nextState)) {
            return false;
        }
        boolean interruptible = duration == 0.0f;
        Timer timer = interruptible ? Timer.infinite() : new Timer(duration);
        StateQueueElement<S> element = new StateQueueElement<S>(nextState, timer, interruptible);
        this.stateQueue.offer(element);
        return true;
    }

    public void forceState(S nextState) {
        this.stateQueue.clear();
        this.requestState(nextState);
    }

    private boolean isTransitionAllowed(S requestedState) {
        if (this.stateQueue.isEmpty()) {
            return !requestedState.equals(this.defaultState);
        }
        Object precedingState = this.stateQueue.getLast().state;
        return !requestedState.equals(precedingState);
    }

    @Override
    public void update(float deltaTime) {
        if (this.isActiveStateCompleted()) {
            this.stateQueue.pop();
        }
        if (this.stateQueue.isEmpty()) {
            this.updateState(this.defaultState, deltaTime);
            return;
        }
        StateQueueElement<S> active = this.stateQueue.peek();
        this.updateState(active, deltaTime);
        if (this.isActiveStateCompleted()) {
            this.stateQueue.pop();
        }
    }

    private void updateState(StateQueueElement<S> element, float deltaTime) {
        element.timer.update(deltaTime);
        Object s = element.state;
        if (s instanceof Updatable) {
            Updatable updatableState = (Updatable)s;
            updatableState.update(deltaTime);
        }
    }

    public S getActiveState() {
        StateQueueElement<S> active = this.stateQueue.peek();
        if (active == null) {
            active = this.defaultState;
        }
        return active.state;
    }

    public Timer getActiveStateTimer() {
        StateQueueElement<S> active = this.stateQueue.peek();
        if (active == null) {
            active = this.defaultState;
        }
        return active.timer;
    }

    private boolean isActiveStateCompleted() {
        if (this.stateQueue.isEmpty()) {
            return false;
        }
        StateQueueElement<S> active = this.stateQueue.peek();
        boolean hasNextState = this.stateQueue.size() >= 2;
        return active.timer.isCompleted() || active.interruptible && hasNextState;
    }

    private record StateQueueElement<S>(S state, Timer timer, boolean interruptible) {
    }
}

