/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.StageNode2D;
import nl.colorize.util.LogHelper;
import nl.colorize.util.animation.Timeline;

@Deprecated
public final class Effect
implements Scene {
    private List<Updatable> frameHandlers = new ArrayList<Updatable>();
    private List<ClickHandler> clickHandlers = new ArrayList<ClickHandler>();
    private List<Runnable> completionHandlers = new ArrayList<Runnable>();
    private List<StageNode2D> linkedGraphics = new ArrayList<StageNode2D>();
    private List<BooleanSupplier> completionConditions = new ArrayList<BooleanSupplier>();
    private boolean completed = false;
    private static final Logger LOGGER = LogHelper.getLogger(Effect.class);

    public Effect addFrameHandler(Updatable handler) {
        this.frameHandlers.add(handler);
        return this;
    }

    public Effect addFrameHandler(Runnable handler) {
        this.frameHandlers.add(deltaTime -> handler.run());
        return this;
    }

    public Effect addTimerHandler(Timer timer, Consumer<Float> callback) {
        this.addFrameHandler((float deltaTime) -> {
            timer.update(deltaTime);
            callback.accept(Float.valueOf(timer.getTime()));
        });
        this.stopIf(() -> timer.isCompleted());
        return this;
    }

    public Effect addTimelineHandler(Timeline timeline, Consumer<Float> callback) {
        this.addFrameHandler((float deltaTime) -> {
            timeline.movePlayhead(deltaTime);
            callback.accept(Float.valueOf(timeline.getValue()));
        });
        this.stopIf(() -> timeline.isCompleted() && !timeline.isLoop());
        return this;
    }

    public Effect addClickHandler(Rect bounds, Runnable handler) {
        return this.addClickHandler(() -> bounds, handler);
    }

    public Effect addClickHandler(Supplier<Rect> bounds, Runnable handler) {
        this.clickHandlers.add(new ClickHandler(bounds, handler));
        return this;
    }

    public Effect addClickHandler(StageNode2D graphic, Runnable handler) {
        return this.addClickHandler(() -> graphic.getStageBounds(), handler);
    }

    public Effect addCompletionHandler(Runnable handler) {
        this.completionHandlers.add(handler);
        return this;
    }

    public Effect stopAfter(float duration) {
        Timer timer = new Timer(duration);
        this.addFrameHandler(timer);
        this.stopIf(timer::isCompleted);
        return this;
    }

    public Effect stopAfterAnimation(Sprite sprite) {
        Animation currentStateGraphics = sprite.getCurrentStateGraphics();
        float duration = currentStateGraphics.getDuration();
        if (duration == 0.0f) {
            LOGGER.warning("Cannot bind effect to zero-length animation");
            return this;
        }
        return this.stopAfter(duration);
    }

    public Effect stopIf(BooleanSupplier condition) {
        this.completionConditions.add(condition);
        return this;
    }

    public Effect stopNow() {
        this.completionConditions.add(() -> true);
        return this;
    }

    public Effect stopNever() {
        this.completionConditions.add(() -> false);
        return this;
    }

    public Effect linkGraphics(StageNode2D ... graphics) {
        for (StageNode2D graphic : graphics) {
            this.linkedGraphics.add(graphic);
        }
        return this;
    }

    @Deprecated
    public Effect removeAfterwards(StageNode2D ... graphics) {
        return this.linkGraphics(graphics);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        if (!this.completed) {
            this.updateHandlers(context, deltaTime);
            if (this.checkCompleted()) {
                this.completed = true;
            }
        }
    }

    private void updateHandlers(SceneContext context, float deltaTime) {
        for (Updatable frameHandler : this.frameHandlers) {
            frameHandler.update(deltaTime);
        }
        for (Pointer pointer : context.getInput().getPointers()) {
            for (ClickHandler clickHandler : this.clickHandlers) {
                if (!pointer.isReleased(clickHandler.bounds.get()) || !this.checkVisible()) continue;
                clickHandler.action.run();
                context.getInput().clearPointerState();
            }
        }
    }

    private boolean checkVisible() {
        if (this.linkedGraphics.isEmpty()) {
            return true;
        }
        return this.linkedGraphics.stream().anyMatch(graphic -> graphic.getTransform().isVisible());
    }

    private boolean checkCompleted() {
        if (this.completionConditions.isEmpty()) {
            return false;
        }
        return this.completionConditions.stream().allMatch(BooleanSupplier::getAsBoolean);
    }

    @Override
    public void end(SceneContext context) {
        for (Runnable completionHandler : this.completionHandlers) {
            completionHandler.run();
        }
        for (StageNode2D graphic : this.linkedGraphics) {
            context.getStage().detach(graphic);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Deprecated
    public void withLinkedGraphics(Consumer<StageNode2D> callback) {
        this.linkedGraphics.forEach(callback);
    }

    @Deprecated
    public <T extends StageNode2D> void withLinkedGraphics(Class<T> type, Consumer<T> callback) {
        this.linkedGraphics.stream().filter(graphic -> graphic.getClass().equals(type)).forEach(graphic -> callback.accept(graphic));
    }

    public Effect attach(SceneContext context) {
        context.attach(this);
        return this;
    }

    public static Effect delay(float duration, Runnable action) {
        Timer timer = new Timer(duration);
        AtomicBoolean done = new AtomicBoolean(false);
        Effect effect = new Effect();
        effect.addFrameHandler((float deltaTime) -> {
            timer.update(deltaTime);
            if (timer.isCompleted() && !done.get()) {
                action.run();
                done.set(true);
            }
        });
        effect.stopIf(timer::isCompleted);
        return effect;
    }

    private record ClickHandler(Supplier<Rect> bounds, Runnable action) {
    }
}

